/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.sequentialinbox.inbox;

import ch.admin.bit.jeap.messaging.avro.AvroMessage;
import ch.admin.bit.jeap.messaging.avro.AvroMessageKey;
import ch.admin.bit.jeap.messaging.sequentialinbox.inbox.DeserializedMessage;
import ch.admin.bit.jeap.messaging.sequentialinbox.spring.MessageHandlerProvider;
import ch.admin.bit.jeap.messaging.sequentialinbox.spring.SequentialInboxMessageHandler;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.TransactionTemplate;

@Component
class MessageHandlerService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MessageHandlerService.class);
    private static final DefaultTransactionDefinition NOT_SUPPORTED = new DefaultTransactionDefinition(4);
    private final MessageHandlerProvider messageHandlerProvider;
    private final PlatformTransactionManager platformTransactionManager;

    void handle(DeserializedMessage deserializedMessage) {
        SequentialInboxMessageHandler messageHandler = this.messageHandlerProvider.getHandlerForMessageType(deserializedMessage.messageType());
        this.invokeMessageHandler(deserializedMessage, messageHandler);
    }

    private void invokeMessageHandler(DeserializedMessage deserializedMessage, SequentialInboxMessageHandler messageHandler) {
        this.invokeMessageHandler(deserializedMessage.key(), deserializedMessage.message(), messageHandler);
    }

    void invokeMessageHandler(AvroMessageKey key, AvroMessage message, SequentialInboxMessageHandler messageHandler) {
        TransactionTemplate transactionTemplate = new TransactionTemplate(this.platformTransactionManager, (TransactionDefinition)NOT_SUPPORTED);
        transactionTemplate.executeWithoutResult(ignored -> messageHandler.invoke(key, message));
    }

    @Generated
    public MessageHandlerService(MessageHandlerProvider messageHandlerProvider, PlatformTransactionManager platformTransactionManager) {
        this.messageHandlerProvider = messageHandlerProvider;
        this.platformTransactionManager = platformTransactionManager;
    }
}

