/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.sequentialinbox.persistence;

import ch.admin.bit.jeap.messaging.sequentialinbox.persistence.SequenceInstanceState;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;

@Entity
@Table(name="sequence_instance", uniqueConstraints={@UniqueConstraint(name="SEQUENCE_INSTANCE_NAME_CONTEXT_ID_UK", columnNames={"type", "context_id"})})
public class SequenceInstance {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="si_sequence")
    @SequenceGenerator(name="si_sequence", sequenceName="sequence_instance_sequence", allocationSize=50)
    @Column(name="id")
    private Long id;
    @Column(name="name")
    private String name;
    @Column(name="context_id")
    private String contextId;
    @Column(name="state")
    @Enumerated(value=EnumType.STRING)
    private SequenceInstanceState state;
    @Column(name="created_at")
    private ZonedDateTime createdAt;
    @Column(name="closed_at")
    private ZonedDateTime closedAt;
    @Column(name="retain_until", nullable=false)
    private ZonedDateTime retainUntil;

    private SequenceInstance(@NonNull String name, @NonNull String contextId, SequenceInstanceState state, @NonNull Duration retentionPeriod) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (contextId == null) {
            throw new NullPointerException("contextId is marked non-null but is null");
        }
        if (retentionPeriod == null) {
            throw new NullPointerException("retentionPeriod is marked non-null but is null");
        }
        this.name = name;
        this.contextId = contextId;
        this.state = state == null ? SequenceInstanceState.OPEN : state;
        this.createdAt = ZonedDateTime.now();
        this.retainUntil = this.createdAt.plus(retentionPeriod);
    }

    public void close() {
        if (this.state == SequenceInstanceState.OPEN) {
            this.state = SequenceInstanceState.CLOSED;
            this.closedAt = ZonedDateTime.now();
        }
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SequenceInstance that = (SequenceInstance)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hashCode(this.id);
    }

    @Generated
    public static SequenceInstanceBuilder builder() {
        return new SequenceInstanceBuilder();
    }

    @Generated
    protected SequenceInstance() {
    }

    @Generated
    public String toString() {
        return "SequenceInstance(id=" + this.getId() + ", name=" + this.getName() + ", contextId=" + this.getContextId() + ", state=" + String.valueOf((Object)this.getState()) + ", createdAt=" + String.valueOf(this.getCreatedAt()) + ", closedAt=" + String.valueOf(this.getClosedAt()) + ", retainUntil=" + String.valueOf(this.getRetainUntil()) + ")";
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getContextId() {
        return this.contextId;
    }

    @Generated
    public SequenceInstanceState getState() {
        return this.state;
    }

    @Generated
    public ZonedDateTime getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public ZonedDateTime getClosedAt() {
        return this.closedAt;
    }

    @Generated
    public ZonedDateTime getRetainUntil() {
        return this.retainUntil;
    }

    @Generated
    public static class SequenceInstanceBuilder {
        @Generated
        private String name;
        @Generated
        private String contextId;
        @Generated
        private SequenceInstanceState state;
        @Generated
        private Duration retentionPeriod;

        @Generated
        SequenceInstanceBuilder() {
        }

        @Generated
        public SequenceInstanceBuilder name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        @Generated
        public SequenceInstanceBuilder contextId(@NonNull String contextId) {
            if (contextId == null) {
                throw new NullPointerException("contextId is marked non-null but is null");
            }
            this.contextId = contextId;
            return this;
        }

        @Generated
        public SequenceInstanceBuilder state(SequenceInstanceState state) {
            this.state = state;
            return this;
        }

        @Generated
        public SequenceInstanceBuilder retentionPeriod(@NonNull Duration retentionPeriod) {
            if (retentionPeriod == null) {
                throw new NullPointerException("retentionPeriod is marked non-null but is null");
            }
            this.retentionPeriod = retentionPeriod;
            return this;
        }

        @Generated
        public SequenceInstance build() {
            return new SequenceInstance(this.name, this.contextId, this.state, this.retentionPeriod);
        }

        @Generated
        public String toString() {
            return "SequenceInstance.SequenceInstanceBuilder(name=" + this.name + ", contextId=" + this.contextId + ", state=" + String.valueOf((Object)this.state) + ", retentionPeriod=" + String.valueOf(this.retentionPeriod) + ")";
        }
    }
}

