/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.sequentialinbox.inbox;

import java.util.Optional;
import lombok.Generated;
import org.apache.commons.logging.LogFactory;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.serialization.Deserializer;
import org.springframework.core.log.LogAccessor;
import org.springframework.kafka.support.serializer.DeserializationException;
import org.springframework.kafka.support.serializer.SerializationUtils;

final class Deserializers {
    private static final LogAccessor LOGGER = new LogAccessor(LogFactory.getLog(Deserializers.class));

    static <T> T deserialize(Deserializer<T> deserializer, String topic, byte[] bytes, boolean isKey) {
        RecordHeaders headers = new RecordHeaders();
        Object object = deserializer.deserialize(topic, (Headers)headers, bytes);
        Deserializers.checkDeserException(isKey, (Headers)headers);
        return (T)object;
    }

    private static void checkDeserException(boolean isKey, Headers headers) {
        String headerName;
        String string = headerName = isKey ? "springDeserializerExceptionKey" : "springDeserializerExceptionValue";
        if (headers.lastHeader(headerName) != null) {
            Deserializers.throwDeserExceptionIfFound(headers, headerName);
        }
    }

    private static void throwDeserExceptionIfFound(Headers headers, String headerName) {
        ConsumerRecord<Object, Object> recordWithHeaders = Deserializers.createEmptyRecordWithHeaders(headers);
        DeserializationException exceptionFromHeader = SerializationUtils.getExceptionFromHeader(recordWithHeaders, (String)headerName, (LogAccessor)LOGGER);
        if (exceptionFromHeader != null) {
            throw exceptionFromHeader;
        }
    }

    private static ConsumerRecord<Object, Object> createEmptyRecordWithHeaders(Headers headers) {
        return new ConsumerRecord("topic", 0, 0L, -1L, TimestampType.NO_TIMESTAMP_TYPE, -1, -1, null, null, headers, Optional.empty());
    }

    @Generated
    private Deserializers() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

