/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.sequentialinbox.spring;

import ch.admin.bit.jeap.messaging.avro.AvroMessage;
import ch.admin.bit.jeap.messaging.avro.AvroMessageKey;
import ch.admin.bit.jeap.messaging.sequentialinbox.configuration.model.SequencedMessageType;
import ch.admin.bit.jeap.messaging.sequentialinbox.configuration.model.SequentialInboxConfiguration;
import ch.admin.bit.jeap.messaging.sequentialinbox.kafka.KafkaSequentialInboxMessageConsumerFactory;
import ch.admin.bit.jeap.messaging.sequentialinbox.spring.ListenerBeanMethod;
import ch.admin.bit.jeap.messaging.sequentialinbox.spring.MessageHandlerProvider;
import ch.admin.bit.jeap.messaging.sequentialinbox.spring.SequentialInboxException;
import ch.admin.bit.jeap.messaging.sequentialinbox.spring.SequentialInboxMessageHandler;
import ch.admin.bit.jeap.messaging.sequentialinbox.spring.SequentialInboxMessageListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
class SequentialInboxListenerService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SequentialInboxListenerService.class);
    private final KafkaSequentialInboxMessageConsumerFactory messageConsumerFactory;
    private final ApplicationContext applicationContext;
    private final SequentialInboxConfiguration sequentialInboxConfiguration;
    private final MessageHandlerProvider messageHandlerProvider;

    public SequentialInboxListenerService(KafkaSequentialInboxMessageConsumerFactory messageConsumerFactory, ApplicationContext applicationContext, SequentialInboxConfiguration sequentialInboxConfiguration, MessageHandlerProvider messageHandlerProvider) {
        this.messageConsumerFactory = messageConsumerFactory;
        this.applicationContext = applicationContext;
        this.sequentialInboxConfiguration = sequentialInboxConfiguration;
        this.messageHandlerProvider = messageHandlerProvider;
    }

    @EventListener
    public void onAppStarted(ApplicationStartedEvent ignored) {
        this.startMessageListeners();
    }

    void startMessageListeners() {
        Set<SequencedMessageType> messageTypes = this.sequentialInboxConfiguration.getSequencedMessageTypes();
        List<ListenerBeanMethod> allAnnotatedMethods = this.getAllSequentialInboxMessageListenerMethods();
        Set<ListenerBeanMethod> startedListeners = messageTypes.stream().map(messageType -> this.startListener((SequencedMessageType)messageType, allAnnotatedMethods)).collect(Collectors.toSet());
        SequentialInboxListenerService.assertAllAnnotatedListenersStarted(allAnnotatedMethods, startedListeners);
    }

    private static void assertAllAnnotatedListenersStarted(List<ListenerBeanMethod> allAnnotatedMethods, Set<ListenerBeanMethod> startedListeners) {
        HashSet<ListenerBeanMethod> notStartedListeners = new HashSet<ListenerBeanMethod>(allAnnotatedMethods);
        notStartedListeners.removeAll(startedListeners);
        if (!notStartedListeners.isEmpty()) {
            throw SequentialInboxException.unusedMessageHandlers(notStartedListeners);
        }
    }

    private ListenerBeanMethod startListener(SequencedMessageType messageType, List<ListenerBeanMethod> allAnnotatedMethods) {
        SequentialInboxMessageHandler messageHandler = this.getBeanForMessageType(allAnnotatedMethods, messageType.getType());
        this.messageHandlerProvider.addHandler(messageType.getType(), messageHandler);
        this.messageConsumerFactory.startConsumer(messageType.getTopic(), messageType.getType(), messageType.getClusterName(), messageHandler);
        return messageHandler.getListenerBeanMethod();
    }

    private SequentialInboxMessageHandler getBeanForMessageType(List<ListenerBeanMethod> allAnnotatedMethods, String messageType) {
        ArrayList<SequentialInboxMessageHandler> beansForMessageType = new ArrayList<SequentialInboxMessageHandler>();
        for (ListenerBeanMethod listenerBeanMethod : allAnnotatedMethods) {
            Object bean = listenerBeanMethod.bean();
            Method method = listenerBeanMethod.method();
            int paramCount = method.getParameterTypes().length;
            this.validateListenerMethodSignature(method, paramCount);
            if (paramCount == 1 && SequentialInboxListenerService.getParameterType(method, 0).getSimpleName().equals(messageType)) {
                log.info("Found message handler {} for message type {}", (Object)bean.getClass().getName(), (Object)messageType);
                beansForMessageType.add(new SequentialInboxMessageHandler(listenerBeanMethod, false));
            }
            if (paramCount != 2 || !method.getParameterTypes()[1].getSimpleName().equals(messageType)) continue;
            log.info("Found message handler {} with key for message type {}", (Object)bean.getClass().getName(), (Object)messageType);
            beansForMessageType.add(new SequentialInboxMessageHandler(listenerBeanMethod, true));
        }
        if (beansForMessageType.isEmpty()) {
            throw SequentialInboxException.noMessageHandlerFound(messageType);
        }
        if (beansForMessageType.size() != 1) {
            throw SequentialInboxException.multipleMessageHandlersFound(messageType, beansForMessageType);
        }
        return (SequentialInboxMessageHandler)beansForMessageType.getFirst();
    }

    private void validateListenerMethodSignature(Method method, int paramCount) {
        SequentialInboxListenerService.assertParamCount(method, paramCount);
        if (paramCount == 1 && !AvroMessage.class.isAssignableFrom(SequentialInboxListenerService.getParameterType(method, 0))) {
            throw SequentialInboxException.invalidListenerMethodSignature(method);
        }
        if (!(paramCount != 2 || AvroMessageKey.class.isAssignableFrom(SequentialInboxListenerService.getParameterType(method, 0)) && AvroMessage.class.isAssignableFrom(SequentialInboxListenerService.getParameterType(method, 1)))) {
            throw SequentialInboxException.invalidListenerMethodSignature(method);
        }
    }

    private static Class<?> getParameterType(Method method, int pos) {
        return method.getParameterTypes()[pos];
    }

    private List<ListenerBeanMethod> getAllSequentialInboxMessageListenerMethods() {
        return Arrays.stream(this.applicationContext.getBeanDefinitionNames()).map(arg_0 -> ((ApplicationContext)this.applicationContext).getBean(arg_0)).flatMap(SequentialInboxListenerService::getSequentialInboxMessageListenerMethods).toList();
    }

    private static Stream<ListenerBeanMethod> getSequentialInboxMessageListenerMethods(Object bean) {
        return Arrays.stream(AopUtils.getTargetClass((Object)bean).getMethods()).filter(method -> method.isAnnotationPresent(SequentialInboxMessageListener.class)).map(method -> new ListenerBeanMethod((Method)method, bean, SequentialInboxListenerService.getMessageTypeClass(method)));
    }

    private static Class<AvroMessage> getMessageTypeClass(Method method) {
        int paramCount = method.getParameterTypes().length;
        SequentialInboxListenerService.assertParamCount(method, paramCount);
        int lastParameterIndex = paramCount - 1;
        return SequentialInboxListenerService.getParameterType(method, lastParameterIndex);
    }

    private static void assertParamCount(Method method, int paramCount) {
        if (paramCount < 1 || paramCount > 2) {
            throw SequentialInboxException.invalidListenerMethodSignature(method);
        }
    }
}

