/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.sequentialinbox.configuration.model;

import ch.admin.bit.jeap.messaging.sequentialinbox.configuration.deserializer.SequentialInboxConfigurationException;
import ch.admin.bit.jeap.messaging.sequentialinbox.configuration.model.ReleaseConditionsValidator;
import ch.admin.bit.jeap.messaging.sequentialinbox.configuration.model.Sequence;
import ch.admin.bit.jeap.messaging.sequentialinbox.configuration.model.SequencedMessageType;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class SequentialInboxConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SequentialInboxConfiguration.class);
    @JsonProperty(value="sequences")
    private List<Sequence> sequences;
    private Map<String, Sequence> sequenceByMessageTypeName;
    private Map<String, SequencedMessageType> sequencedMessageTypeByName;

    public void validateAndInitialize() {
        this.checkDuplicatedMessageTypesAndTopics();
        this.checkRetentionPeriod();
        this.sequenceByMessageTypeName = new HashMap<String, Sequence>();
        this.sequencedMessageTypeByName = new HashMap<String, SequencedMessageType>();
        for (Sequence sequence : this.sequences) {
            SequentialInboxConfiguration.validateSequence(sequence);
            sequence.init();
            for (SequencedMessageType message : sequence.getMessages()) {
                this.sequenceByMessageTypeName.put(message.getType(), sequence);
                this.sequencedMessageTypeByName.put(message.getType(), message);
            }
        }
    }

    private void checkRetentionPeriod() {
        this.sequences.forEach(sequence -> {
            if (sequence.getRetentionPeriod() == null || sequence.getRetentionPeriod().toMinutes() == 0L) {
                throw SequentialInboxConfigurationException.retentionPeriodMissing(sequence.getName());
            }
        });
    }

    public Sequence getSequenceByMessageTypeName(String messageTypeName) {
        return this.sequenceByMessageTypeName.get(messageTypeName);
    }

    public SequencedMessageType requireSequencedMessageTypeByName(String messageTypeName) {
        SequencedMessageType sequencedMessageType = this.sequencedMessageTypeByName.get(messageTypeName);
        if (sequencedMessageType == null) {
            throw SequentialInboxConfigurationException.messageTypeNotConfiguredInAnySequence(messageTypeName);
        }
        return sequencedMessageType;
    }

    private static void validateSequence(Sequence sequence) {
        if (!StringUtils.hasText((String)sequence.getName())) {
            throw SequentialInboxConfigurationException.missingSequenceName();
        }
        if (sequence.getMessages() == null || sequence.getMessages().isEmpty()) {
            throw SequentialInboxConfigurationException.emptySequence(sequence.getName());
        }
        sequence.getMessages().forEach(message -> SequentialInboxConfiguration.validateSequencedMessageType(sequence.getName(), message));
        ReleaseConditionsValidator validator = new ReleaseConditionsValidator(sequence.getMessages());
        validator.validate();
    }

    private static void validateSequencedMessageType(String sequenceName, SequencedMessageType sequencedMessageType) {
        if (!StringUtils.hasText((String)sequencedMessageType.getType())) {
            throw SequentialInboxConfigurationException.missingMessageType(sequenceName);
        }
        if (sequencedMessageType.getContextIdExtractor() == null) {
            throw SequentialInboxConfigurationException.missingContextIdExtractor(sequenceName);
        }
    }

    private void checkDuplicatedMessageTypesAndTopics() {
        log.debug("Checking duplicated message types and topics");
        HashSet messageTypes = new HashSet();
        HashSet<String> duplicatedMessageTypes = new HashSet<String>();
        HashSet topics = new HashSet();
        HashSet<String> duplicatedTopics = new HashSet<String>();
        this.sequences.forEach(sequence -> sequence.getMessages().forEach(message -> {
            String type = message.getType();
            String topic = message.getTopic();
            if (!messageTypes.add(type)) {
                duplicatedMessageTypes.add(type);
            }
            if (topic != null && !topics.add(topic)) {
                duplicatedTopics.add(topic);
            }
        }));
        if (!duplicatedMessageTypes.isEmpty()) {
            throw SequentialInboxConfigurationException.duplicatedMessageTypes(duplicatedMessageTypes);
        }
        if (!duplicatedTopics.isEmpty()) {
            throw SequentialInboxConfigurationException.duplicatedTopics(duplicatedTopics);
        }
    }

    public Set<SequencedMessageType> getSequencedMessageTypes() {
        return this.sequences.stream().flatMap(sequence -> sequence.getMessages().stream()).collect(Collectors.toSet());
    }

    public int getSequenceCount() {
        return this.sequences.size();
    }

    public String toString() {
        return this.sequences.toString();
    }
}

