/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.sequentialinbox.inbox;

import ch.admin.bit.jeap.messaging.avro.AvroMessage;
import ch.admin.bit.jeap.messaging.avro.AvroMessageKey;
import ch.admin.bit.jeap.messaging.kafka.errorhandling.ClusterNameHeaderInterceptor;
import ch.admin.bit.jeap.messaging.kafka.properties.KafkaProperties;
import ch.admin.bit.jeap.messaging.sequentialinbox.configuration.model.Sequence;
import ch.admin.bit.jeap.messaging.sequentialinbox.configuration.model.SequencedMessageType;
import ch.admin.bit.jeap.messaging.sequentialinbox.jpa.MessageRepository;
import ch.admin.bit.jeap.messaging.sequentialinbox.kafka.TraceContextFactory;
import ch.admin.bit.jeap.messaging.sequentialinbox.metrics.SequentialInboxMetricsCollector;
import ch.admin.bit.jeap.messaging.sequentialinbox.persistence.BufferedMessage;
import ch.admin.bit.jeap.messaging.sequentialinbox.persistence.MessageHeader;
import ch.admin.bit.jeap.messaging.sequentialinbox.persistence.SequencedMessage;
import ch.admin.bit.jeap.messaging.sequentialinbox.persistence.SequencedMessageState;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component
class SequencedMessageService {
    private final TraceContextFactory traceContextFactory;
    private final MessageRepository messageRepository;
    private final KafkaProperties kafkaProperties;
    private final SequentialInboxMetricsCollector metricsCollector;
    private static final List<String> PRESERVED_HEADER_NAMES = List.of("jeap_encrypted_value", "jeap-cert", "jeap-sign", "jeap-sign-key");

    @Transactional(propagation=Propagation.REQUIRES_NEW, isolation=Isolation.READ_COMMITTED)
    public void storeSequencedMessage(Optional<SequencedMessage> existingSequencedMessage, long sequenceInstanceId, SequencedMessageState state, ConsumerRecord<AvroMessageKey, AvroMessage> consumerRecord) {
        String messageType = ((AvroMessage)consumerRecord.value()).getType().getName();
        if (existingSequencedMessage.isPresent()) {
            this.messageRepository.setMessageStateInCurrentTransaction(existingSequencedMessage.get(), state);
            return;
        }
        this.metricsCollector.onConsumedSequencedMessage(messageType);
        BufferedMessage bufferedMessage = null;
        if (state == SequencedMessageState.WAITING) {
            bufferedMessage = BufferedMessage.builder().sequenceInstanceId(sequenceInstanceId).key(consumerRecord.key() == null ? null : ((AvroMessageKey)consumerRecord.key()).getSerializedMessage()).value(((AvroMessage)consumerRecord.value()).getSerializedMessage()).build();
            bufferedMessage.setHeaders(this.getMessageHeaders(consumerRecord.headers(), bufferedMessage));
        }
        String clusterName = this.getClusterName(consumerRecord);
        SequencedMessage sequencedMessage = SequencedMessage.builder().messageType(messageType).sequenceInstanceId(sequenceInstanceId).clusterName(clusterName).topic(consumerRecord.topic()).sequencedMessageId(UUID.fromString(((AvroMessage)consumerRecord.value()).getIdentity().getId())).idempotenceId(((AvroMessage)consumerRecord.value()).getIdentity().getIdempotenceId()).traceContext(this.traceContextFactory.currentTraceContext()).state(state).build();
        this.messageRepository.saveMessage(bufferedMessage, sequencedMessage);
    }

    private List<MessageHeader> getMessageHeaders(Headers headers, BufferedMessage bufferedMessage) {
        ArrayList<MessageHeader> messageHeaders = new ArrayList<MessageHeader>();
        for (String headerName : PRESERVED_HEADER_NAMES) {
            Header header = headers.lastHeader(headerName);
            if (header == null) continue;
            messageHeaders.add(MessageHeader.builder().headerName(headerName).headerValue(header.value()).bufferedMessage(bufferedMessage).build());
        }
        return messageHeaders;
    }

    private String getClusterName(ConsumerRecord<AvroMessageKey, AvroMessage> consumerRecord) {
        String clusterName = ClusterNameHeaderInterceptor.getClusterName(consumerRecord);
        return clusterName == null ? this.kafkaProperties.getDefaultClusterName() : clusterName;
    }

    Optional<SequencedMessage> findByMessageTypeAndIdempotenceId(String messageType, String idempotenceId) {
        return this.messageRepository.findByMessageTypeAndIdempotenceIdInNewTransaction(messageType, idempotenceId);
    }

    boolean isReleaseConditionSatisfied(SequencedMessageType sequencedMessageType, long sequenceInstanceId) {
        Set<String> emptyProcessedMessageSet = Set.of();
        if (sequencedMessageType.isReleaseConditionSatisfied(emptyProcessedMessageSet)) {
            return true;
        }
        Set<String> processedMessageTypes = this.messageRepository.getProcessedMessageTypesInSequenceInNewTransaction(sequenceInstanceId);
        return sequencedMessageType.isReleaseConditionSatisfied(processedMessageTypes);
    }

    boolean areAllMessagesProcessed(Sequence sequence, long sequenceInstanceId) {
        Set<String> allMessageTypeNames = sequence.getMessageTypeNames();
        Set<String> processedMessageTypes = this.messageRepository.getProcessedMessageTypesInSequenceInNewTransaction(sequenceInstanceId);
        return allMessageTypeNames.equals(processedMessageTypes);
    }

    @Generated
    public SequencedMessageService(TraceContextFactory traceContextFactory, MessageRepository messageRepository, KafkaProperties kafkaProperties, SequentialInboxMetricsCollector metricsCollector) {
        this.traceContextFactory = traceContextFactory;
        this.messageRepository = messageRepository;
        this.kafkaProperties = kafkaProperties;
        this.metricsCollector = metricsCollector;
    }
}

