/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.sequentialinbox.inbox;

import ch.admin.bit.jeap.messaging.avro.AvroMessage;
import ch.admin.bit.jeap.messaging.avro.AvroMessageKey;
import ch.admin.bit.jeap.messaging.kafka.KafkaConfiguration;
import ch.admin.bit.jeap.messaging.kafka.properties.KafkaProperties;
import ch.admin.bit.jeap.messaging.sequentialinbox.inbox.DeserializedMessage;
import ch.admin.bit.jeap.messaging.sequentialinbox.inbox.Deserializers;
import ch.admin.bit.jeap.messaging.sequentialinbox.persistence.BufferedMessage;
import ch.admin.bit.jeap.messaging.sequentialinbox.persistence.SequencedMessage;
import jakarta.annotation.PostConstruct;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.common.serialization.Deserializer;
import org.springframework.stereotype.Component;

@Component
class SequentialInboxDeserializer {
    private final KafkaProperties kafkaProperties;
    private final KafkaConfiguration kafkaConfiguration;
    private final Map<String, Deserializer<AvroMessage>> valueDeserializerByClusterName = new ConcurrentHashMap<String, Deserializer<AvroMessage>>();
    private final Map<String, Deserializer<AvroMessageKey>> keyDeserializerByClusterName = new ConcurrentHashMap<String, Deserializer<AvroMessageKey>>();

    DeserializedMessage deserialize(SequencedMessage sequencedMessage, BufferedMessage bufferedMessage) {
        String topic = sequencedMessage.getTopic();
        String clusterNameOrDefault = this.getClusterNameOrDefault(sequencedMessage);
        Deserializer<AvroMessage> valueDeserializer = this.valueDeserializerByClusterName.get(clusterNameOrDefault);
        Deserializer<AvroMessageKey> keyDeserializer = this.keyDeserializerByClusterName.get(clusterNameOrDefault);
        AvroMessageKey key = Deserializers.deserialize(keyDeserializer, topic, bufferedMessage.getKey(), Collections.emptyList(), true);
        AvroMessage value = Deserializers.deserialize(valueDeserializer, topic, bufferedMessage.getValue(), bufferedMessage.getHeaders(), false);
        return new DeserializedMessage(sequencedMessage.getMessageType(), key, value);
    }

    private String getClusterNameOrDefault(SequencedMessage sequencedMessage) {
        String clusterName = sequencedMessage.getClusterName();
        return this.valueDeserializerByClusterName.containsKey(clusterName) ? clusterName : this.kafkaProperties.getDefaultClusterName();
    }

    @PostConstruct
    void init() {
        this.kafkaProperties.clusterNames().forEach(this::prepareDeserializers);
    }

    private void prepareDeserializers(String clusterName) {
        ConsumerConfig consumerConfig = new ConsumerConfig(this.kafkaConfiguration.consumerConfig(clusterName));
        this.addValueDeserializer(clusterName, consumerConfig);
        this.addKeyDeserialized(clusterName, consumerConfig);
    }

    private void addValueDeserializer(String clusterName, ConsumerConfig consumerConfig) {
        Deserializer valueDeserializer = (Deserializer)consumerConfig.getConfiguredInstance("value.deserializer", Deserializer.class);
        valueDeserializer.configure(consumerConfig.originals(), false);
        this.valueDeserializerByClusterName.put(clusterName, (Deserializer<AvroMessage>)valueDeserializer);
    }

    private void addKeyDeserialized(String clusterName, ConsumerConfig consumerConfig) {
        Deserializer keyDeserializer = (Deserializer)consumerConfig.getConfiguredInstance("key.deserializer", Deserializer.class);
        keyDeserializer.configure(consumerConfig.originals(), true);
        this.keyDeserializerByClusterName.put(clusterName, (Deserializer<AvroMessageKey>)keyDeserializer);
    }

    @Generated
    public SequentialInboxDeserializer(KafkaProperties kafkaProperties, KafkaConfiguration kafkaConfiguration) {
        this.kafkaProperties = kafkaProperties;
        this.kafkaConfiguration = kafkaConfiguration;
    }
}

