/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.sequentialinbox.metrics;

import ch.admin.bit.jeap.messaging.sequentialinbox.configuration.model.SequencedMessageType;
import ch.admin.bit.jeap.messaging.sequentialinbox.configuration.model.SequentialInboxConfiguration;
import ch.admin.bit.jeap.messaging.sequentialinbox.metrics.SequentialInboxMetricsCollector;
import ch.admin.bit.jeap.messaging.sequentialinbox.metrics.SequentialInboxPersistenceMetrics;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import jakarta.annotation.PostConstruct;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import lombok.Generated;
import org.springframework.scheduling.annotation.Scheduled;

class SequentialInboxMetrics
implements SequentialInboxMetricsCollector {
    private static final String WAITING_MESSAGES = "jeap.messaging.sequential-inbox.metrics.waiting-messages";
    private static final String CONSUMED_MESSAGES = "jeap.messaging.sequential-inbox.metrics.consumed-messages";
    private static final String WAITING_MESSAGE_DELAY = "jeap.messaging.sequential-inbox.metrics.waiting-message-delay";
    private static final String TYPE_TAG = "type";
    private final MeterRegistry meterRegistry;
    private final SequentialInboxConfiguration config;
    private final SequentialInboxPersistenceMetrics persistenceMetrics;

    @PostConstruct
    public void initMetrics() {
        this.persistenceMetrics.updateMetrics();
        this.sequencedMessageTypes().forEach(this::registerTypeMetrics);
    }

    private void registerTypeMetrics(String type) {
        this.meterRegistry.gauge(WAITING_MESSAGES, (Iterable)Tags.of((String)TYPE_TAG, (String)type), (Object)type, this.persistenceMetrics::getWaitingMessagesOfType);
    }

    @Scheduled(fixedRateString="${jeap.messaging.sequential-inbox.metrics.update-rate-minutes:5}", timeUnit=TimeUnit.MINUTES)
    public void onScheduleMetricsUpdate() {
        this.persistenceMetrics.updateMetrics();
    }

    @Override
    public void onWaitingMessageCompleted(String messageType, Duration waitDuration) {
        this.meterRegistry.timer(WAITING_MESSAGE_DELAY, new String[]{TYPE_TAG, messageType}).record(waitDuration);
    }

    @Override
    public void onConsumedSequencedMessage(String messageType) {
        this.meterRegistry.counter(CONSUMED_MESSAGES, new String[]{TYPE_TAG, messageType}).increment();
    }

    private Stream<String> sequencedMessageTypes() {
        return this.config.getSequencedMessageTypes().stream().map(SequencedMessageType::getQualifiedName);
    }

    @Generated
    public SequentialInboxMetrics(MeterRegistry meterRegistry, SequentialInboxConfiguration config, SequentialInboxPersistenceMetrics persistenceMetrics) {
        this.meterRegistry = meterRegistry;
        this.config = config;
        this.persistenceMetrics = persistenceMetrics;
    }
}

