/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.sequentialinbox.kafka;

import ch.admin.bit.jeap.messaging.kafka.tracing.TraceContext;
import ch.admin.bit.jeap.messaging.kafka.tracing.TraceContextProvider;
import ch.admin.bit.jeap.messaging.sequentialinbox.persistence.SequentialInboxTraceContext;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TraceContextFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TraceContextFactory.class);
    private final Optional<TraceContextProvider> traceContextProvider;

    public SequentialInboxTraceContext currentTraceContext() {
        if (this.traceContextProvider.isEmpty()) {
            return SequentialInboxTraceContext.empty();
        }
        return TraceContextFactory.createCurrentTraceContext(this.traceContextProvider.get());
    }

    private static SequentialInboxTraceContext createCurrentTraceContext(TraceContextProvider traceContextProvider) {
        TraceContext traceContext = traceContextProvider.getTraceContext();
        if (traceContext == null) {
            return SequentialInboxTraceContext.empty();
        }
        return SequentialInboxTraceContext.builder().traceIdHigh(traceContext.getTraceIdHigh()).traceId(traceContext.getTraceId()).spanId(traceContext.getSpanId()).parentSpanId(traceContext.getParentSpanId()).traceIdString(traceContext.getTraceIdString()).build();
    }

    @Generated
    public TraceContextFactory(Optional<TraceContextProvider> traceContextProvider) {
        this.traceContextProvider = traceContextProvider;
    }
}

