/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.sequentialinbox.inbox;

import ch.admin.bit.jeap.messaging.sequentialinbox.configuration.model.Sequence;
import ch.admin.bit.jeap.messaging.sequentialinbox.inbox.Transactions;
import ch.admin.bit.jeap.messaging.sequentialinbox.jpa.SequenceInstanceRepository;
import ch.admin.bit.jeap.messaging.sequentialinbox.persistence.SequenceInstance;
import ch.admin.bit.jeap.messaging.sequentialinbox.spring.SequentialInboxException;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.stereotype.Component;

@Component
class SequenceInstanceFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SequenceInstanceFactory.class);
    private final SequenceInstanceRepository repository;
    private final Transactions tx;
    private final int idleLockTimeoutSeconds;

    SequenceInstanceFactory(SequenceInstanceRepository repository, Transactions tx, @Value(value="${jeap.messaging.sequential-inbox.idle-lock-timeout-seconds:600}") int idleLockTimeoutSeconds) {
        this.repository = repository;
        this.tx = tx;
        this.idleLockTimeoutSeconds = idleLockTimeoutSeconds;
        log.info("Setting idle lock timeout to {} seconds for sequential inbox transactions", (Object)idleLockTimeoutSeconds);
    }

    SequenceInstance getExistingSequenceInstanceAndLockForUpdate(long sequenceInstanceId) {
        return this.repository.getByIdAndLockForUpdate(sequenceInstanceId, this.idleLockTimeoutSeconds);
    }

    long createOrGetSequenceInstance(Sequence sequence, String contextId) {
        try {
            return this.tx.callInNewTransaction(() -> {
                Optional<Long> existingInstance = this.repository.findIdByNameAndContextId(sequence.getName(), contextId);
                return existingInstance.orElseGet(() -> this.saveNewInstance(sequence, contextId).getId());
            });
        }
        catch (DataIntegrityViolationException e) {
            return (Long)this.tx.callInNewTransaction(() -> this.repository.findIdByNameAndContextId(sequence.getName(), contextId)).orElseThrow(() -> SequentialInboxException.failedToReadExistingSequenceInstance(sequence, contextId, e));
        }
    }

    private SequenceInstance saveNewInstance(Sequence sequence, String contextId) {
        SequenceInstance newInstance = SequenceInstance.builder().contextId(contextId).name(sequence.getName()).retentionPeriod(sequence.getRetentionPeriod()).build();
        return this.repository.save(newInstance);
    }
}

