/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.sequentialinbox.jpa;

import ch.admin.bit.jeap.messaging.sequentialinbox.jpa.SpringDataJpaSequenceInstanceRepository;
import ch.admin.bit.jeap.messaging.sequentialinbox.persistence.SequenceInstance;
import jakarta.persistence.EntityManager;
import java.time.ZonedDateTime;
import java.util.Optional;
import lombok.Generated;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional(propagation=Propagation.MANDATORY)
public class SequenceInstanceRepository {
    private final SpringDataJpaSequenceInstanceRepository springDataJpaSequenceInstanceRepository;
    private final EntityManager entityManager;

    @Transactional
    public SequenceInstance save(SequenceInstance sequenceInstance) {
        SequenceInstance persistedInstance = (SequenceInstance)this.springDataJpaSequenceInstanceRepository.save(sequenceInstance);
        this.springDataJpaSequenceInstanceRepository.flush();
        return persistedInstance;
    }

    public Optional<Long> findIdByNameAndContextId(String name, String contextId) {
        return this.springDataJpaSequenceInstanceRepository.findIdByNameAndContextId(name, contextId);
    }

    public SequenceInstance getByIdAndLockForUpdate(long id, int idleLockTimeoutSeconds) {
        this.setIdleLockTimeoutForCurrentTransaction(idleLockTimeoutSeconds);
        return this.springDataJpaSequenceInstanceRepository.getByIdAndLockForUpdate(id);
    }

    private void setIdleLockTimeoutForCurrentTransaction(int idleLockTimeoutSeconds) {
        if (idleLockTimeoutSeconds < 0) {
            return;
        }
        int millis = idleLockTimeoutSeconds * 1000;
        String queryString = "SET LOCAL idle_in_transaction_session_timeout = '" + millis + "'";
        this.entityManager.createNativeQuery(queryString).executeUpdate();
    }

    @Transactional(propagation=Propagation.MANDATORY)
    public int deleteAllClosed() {
        return this.springDataJpaSequenceInstanceRepository.deleteAllClosed();
    }

    @Transactional(propagation=Propagation.MANDATORY)
    public int deleteExpiredInstances(ZonedDateTime cutoffTime) {
        return this.springDataJpaSequenceInstanceRepository.deleteExpiredInstances(cutoffTime);
    }

    @Generated
    public SequenceInstanceRepository(SpringDataJpaSequenceInstanceRepository springDataJpaSequenceInstanceRepository, EntityManager entityManager) {
        this.springDataJpaSequenceInstanceRepository = springDataJpaSequenceInstanceRepository;
        this.entityManager = entityManager;
    }
}

