/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.sequentialinbox.configuration.model;

import ch.admin.bit.jeap.messaging.avro.AvroMessage;
import ch.admin.bit.jeap.messaging.sequentialinbox.configuration.deserializer.SequentialInboxConfigurationException;
import ch.admin.bit.jeap.messaging.sequentialinbox.configuration.model.ConfigurationValidator;
import ch.admin.bit.jeap.messaging.sequentialinbox.configuration.model.Sequence;
import ch.admin.bit.jeap.messaging.sequentialinbox.configuration.model.SequencedMessageType;
import ch.admin.bit.jeap.messaging.sequentialinbox.configuration.model.SubTypeResolver;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SequentialInboxConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SequentialInboxConfiguration.class);
    @JsonProperty(value="sequences")
    private List<Sequence> sequences;
    @JsonProperty(value="subTypeResolvers")
    private Map<String, SubTypeResolver<AvroMessage, ?>> subTypeResolvers;
    private Map<String, Sequence> sequenceByQualifiedName;
    private Map<String, SequencedMessageType> sequencedMessageTypeByQualifiedName;

    public void validateAndInitialize() {
        if (this.subTypeResolvers == null) {
            this.subTypeResolvers = Map.of();
        }
        ConfigurationValidator.validate(this.sequences, this.subTypeResolvers);
        this.sequenceByQualifiedName = new HashMap<String, Sequence>();
        this.sequencedMessageTypeByQualifiedName = new HashMap<String, SequencedMessageType>();
        for (Sequence sequence : this.sequences) {
            sequence.init();
            for (SequencedMessageType message : sequence.getMessages()) {
                this.sequenceByQualifiedName.put(message.getQualifiedName(), sequence);
                this.sequencedMessageTypeByQualifiedName.put(message.getQualifiedName(), message);
            }
        }
    }

    public Sequence getSequenceByQualifiedSequencedMessageTypeName(String sequencedMessageTypeQn) {
        return this.sequenceByQualifiedName.get(sequencedMessageTypeQn);
    }

    public SequencedMessageType requireSequencedMessageTypeByQualifiedName(String sequencedMessageTypeQn) {
        SequencedMessageType sequencedMessageType = this.sequencedMessageTypeByQualifiedName.get(sequencedMessageTypeQn);
        if (sequencedMessageType == null) {
            throw SequentialInboxConfigurationException.messageTypeNotConfiguredInAnySequence(sequencedMessageTypeQn);
        }
        return sequencedMessageType;
    }

    public Set<SequencedMessageType> getSequencedMessageTypes() {
        return this.sequences.stream().flatMap(sequence -> sequence.getMessages().stream()).collect(Collectors.toSet());
    }

    public int getSequenceCount() {
        return this.sequences.size();
    }

    public String qualifiedSequencedMessageTypeName(AvroMessage avroMessage) {
        String subType = this.resolveSubtypeIfConfigured(avroMessage);
        return avroMessage.getType().getName() + (String)(subType == null ? "" : "." + subType);
    }

    private String resolveSubtypeIfConfigured(AvroMessage avroMessage) {
        String name = avroMessage.getType().getName();
        SubTypeResolver<AvroMessage, ?> subTypeResolver = this.subTypeResolvers.get(name);
        if (subTypeResolver == null) {
            return null;
        }
        return ((Enum)subTypeResolver.resolveSubType(avroMessage)).name();
    }

    public String toString() {
        return this.sequences.toString();
    }
}

