/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.sequentialinbox.inbox;

import ch.admin.bit.jeap.messaging.avro.AvroMessage;
import ch.admin.bit.jeap.messaging.avro.AvroMessageKey;
import ch.admin.bit.jeap.messaging.kafka.interceptor.Callbacks;
import ch.admin.bit.jeap.messaging.kafka.interceptor.JeapKafkaMessageCallback;
import ch.admin.bit.jeap.messaging.model.Message;
import ch.admin.bit.jeap.messaging.sequentialinbox.inbox.DeserializedMessage;
import ch.admin.bit.jeap.messaging.sequentialinbox.spring.MessageHandlerProvider;
import ch.admin.bit.jeap.messaging.sequentialinbox.spring.SequentialInboxMessageHandler;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.TransactionTemplate;

@Component
class MessageHandlerService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MessageHandlerService.class);
    private static final DefaultTransactionDefinition NOT_SUPPORTED = new DefaultTransactionDefinition(4);
    private final MessageHandlerProvider messageHandlerProvider;
    private final PlatformTransactionManager platformTransactionManager;
    private final List<JeapKafkaMessageCallback> callbacks;

    void handle(DeserializedMessage deserializedMessage) {
        String jeapMessageTypeName = deserializedMessage.message().getType().getName();
        SequentialInboxMessageHandler messageHandler = this.messageHandlerProvider.getHandlerForJeapMessageType(jeapMessageTypeName);
        this.invokeMessageHandler(deserializedMessage, messageHandler);
    }

    private void invokeMessageHandler(DeserializedMessage deserializedMessage, SequentialInboxMessageHandler messageHandler) {
        this.invokeMessageHandler(deserializedMessage.key(), deserializedMessage.message(), messageHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void invokeMessageHandler(AvroMessageKey key, AvroMessage message, SequentialInboxMessageHandler messageHandler) {
        this.callbacks.forEach(callback -> Callbacks.invokeCallback((Message)message, arg_0 -> ((JeapKafkaMessageCallback)callback).beforeConsume(arg_0)));
        try {
            this.doInvokeMessageHandler(key, message, messageHandler);
            this.callbacks.forEach(callback -> Callbacks.invokeCallback((Message)message, arg_0 -> ((JeapKafkaMessageCallback)callback).afterConsume(arg_0)));
        }
        finally {
            this.callbacks.forEach(callback -> Callbacks.invokeCallback((Message)message, arg_0 -> ((JeapKafkaMessageCallback)callback).afterRecord(arg_0)));
        }
    }

    private void doInvokeMessageHandler(AvroMessageKey key, AvroMessage message, SequentialInboxMessageHandler messageHandler) {
        TransactionTemplate transactionTemplate = new TransactionTemplate(this.platformTransactionManager, (TransactionDefinition)NOT_SUPPORTED);
        transactionTemplate.executeWithoutResult(ignored -> messageHandler.invoke(key, message));
    }

    @Generated
    public MessageHandlerService(MessageHandlerProvider messageHandlerProvider, PlatformTransactionManager platformTransactionManager, List<JeapKafkaMessageCallback> callbacks) {
        this.messageHandlerProvider = messageHandlerProvider;
        this.platformTransactionManager = platformTransactionManager;
        this.callbacks = callbacks;
    }
}

