/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.sequentialinbox.configuration.model;

import ch.admin.bit.jeap.messaging.avro.AvroMessage;
import ch.admin.bit.jeap.messaging.sequentialinbox.configuration.deserializer.SequentialInboxConfigurationException;
import ch.admin.bit.jeap.messaging.sequentialinbox.configuration.model.ReleaseConditionsValidator;
import ch.admin.bit.jeap.messaging.sequentialinbox.configuration.model.Sequence;
import ch.admin.bit.jeap.messaging.sequentialinbox.configuration.model.SequencedMessageType;
import ch.admin.bit.jeap.messaging.sequentialinbox.configuration.model.SubTypeResolver;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

class ConfigurationValidator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConfigurationValidator.class);
    private static final String DEFAULT_MESSAGE_TYPE_TOPIC = "<default message type topic>";
    private final List<Sequence> sequences;
    private final Map<String, SubTypeResolver<AvroMessage, ?>> subTypeResolvers;

    static void validate(List<Sequence> sequences, Map<String, SubTypeResolver<AvroMessage, ?>> subTypeResolvers) {
        ConfigurationValidator validator = new ConfigurationValidator(sequences, subTypeResolvers);
        validator.validate();
    }

    private void validate() {
        this.checkDuplicatedMessageTypesAndTopics();
        this.checkRetentionPeriod();
        this.sequences.forEach(ConfigurationValidator::validateSequence);
        this.validateSubtypes();
    }

    private void checkRetentionPeriod() {
        this.sequences.forEach(sequence -> {
            if (sequence.getRetentionPeriod() == null || sequence.getRetentionPeriod().toMinutes() == 0L) {
                throw SequentialInboxConfigurationException.retentionPeriodMissing(sequence.getName());
            }
        });
    }

    private static void validateSequence(Sequence sequence) {
        if (!StringUtils.hasText((String)sequence.getName())) {
            throw SequentialInboxConfigurationException.missingSequenceName();
        }
        if (sequence.getMessages() == null || sequence.getMessages().isEmpty()) {
            throw SequentialInboxConfigurationException.emptySequence(sequence.getName());
        }
        sequence.getMessages().forEach(message -> ConfigurationValidator.validateSequencedMessageType(sequence.getName(), message));
        ReleaseConditionsValidator validator = new ReleaseConditionsValidator(sequence.getMessages());
        validator.validate();
    }

    private static void validateSequencedMessageType(String sequenceName, SequencedMessageType sequencedMessageType) {
        if (!StringUtils.hasText((String)sequencedMessageType.getQualifiedName())) {
            throw SequentialInboxConfigurationException.missingMessageType(sequenceName);
        }
        if (sequencedMessageType.getContextIdExtractor() == null) {
            throw SequentialInboxConfigurationException.missingContextIdExtractor(sequenceName);
        }
    }

    private void checkDuplicatedMessageTypesAndTopics() {
        HashSet messageTypeQualifiedNames = new HashSet();
        HashSet<String> duplicatedMessageTypes = new HashSet<String>();
        this.sequences.forEach(sequence -> sequence.getMessages().forEach(message -> {
            String qualifiedName = message.getQualifiedName();
            if (!messageTypeQualifiedNames.add(qualifiedName)) {
                duplicatedMessageTypes.add(qualifiedName);
            }
        }));
        this.validateAllSubtypesHaveSameTopicConfigured();
        if (!duplicatedMessageTypes.isEmpty()) {
            throw SequentialInboxConfigurationException.duplicatedMessageTypes(duplicatedMessageTypes);
        }
    }

    private void validateAllSubtypesHaveSameTopicConfigured() {
        Map topicsByJeapMessageType = this.sequences.stream().flatMap(s -> s.getMessages().stream()).filter(s -> s.getJeapMessageTypeName() != null).collect(Collectors.groupingBy(SequencedMessageType::getJeapMessageTypeName, Collectors.mapping(this::topicNameOrDefaultTopic, Collectors.toSet())));
        topicsByJeapMessageType.forEach((messageType, topics) -> {
            if (topics.size() > 1) {
                throw SequentialInboxConfigurationException.inconsistentTopicNames(messageType, topics);
            }
        });
        HashSet topics2 = new HashSet();
        HashSet<String> duplicatedTopics = new HashSet<String>();
        topicsByJeapMessageType.values().stream().flatMap(Collection::stream).filter(topic -> !DEFAULT_MESSAGE_TYPE_TOPIC.equals(topic)).forEach(topic -> {
            if (!topics2.add(topic)) {
                duplicatedTopics.add((String)topic);
            }
        });
        if (!duplicatedTopics.isEmpty()) {
            throw SequentialInboxConfigurationException.duplicatedTopics(duplicatedTopics);
        }
    }

    private String topicNameOrDefaultTopic(SequencedMessageType smt) {
        return smt.getTopic() == null ? DEFAULT_MESSAGE_TYPE_TOPIC : smt.getTopic();
    }

    private void validateSubtypes() {
        List<SequencedMessageType> messages = this.sequences.stream().flatMap(sequence -> sequence.getMessages().stream()).toList();
        this.validateTypeAndSubtypeNotMixed(messages);
        this.validateSubTypeResolvers(messages);
    }

    private void validateSubTypeResolvers(Collection<SequencedMessageType> messages) {
        List<TypeWithSubtype> typesWithSubtypes = messages.stream().filter(ConfigurationValidator::hasSubtype).map(smt -> new TypeWithSubtype(smt.getJeapMessageTypeName(), smt.getSubType())).toList();
        typesWithSubtypes.forEach(typeWithSubtype -> {
            if (!this.subTypeResolvers.containsKey(typeWithSubtype.type())) {
                throw SequentialInboxConfigurationException.missingSubTypeResolver(typeWithSubtype.type());
            }
        });
        this.validateAllSubtypesResolvable(messages, typesWithSubtypes);
    }

    private void validateAllSubtypesResolvable(Collection<SequencedMessageType> messages, List<TypeWithSubtype> typesWithSubtypes) {
        HashSet<String> messageTypesWithSubtype = ConfigurationValidator.messageTypesWithSubtypes(messages);
        Map<String, List<TypeWithSubtype>> typeWithSubtypeByMessageType = typesWithSubtypes.stream().collect(Collectors.groupingBy(TypeWithSubtype::type));
        this.subTypeResolvers.forEach((type, resolver) -> {
            if (!messageTypesWithSubtype.contains(type)) {
                throw SequentialInboxConfigurationException.subtypeResolverForBadType(type);
            }
            Set<String> configuredSubTypes = ((List)typeWithSubtypeByMessageType.get(type)).stream().map(TypeWithSubtype::subType).collect(Collectors.toSet());
            ConfigurationValidator.validateSubTypeEnumConfiguration(type, resolver, configuredSubTypes);
        });
    }

    private static void validateSubTypeEnumConfiguration(String type, SubTypeResolver<?, ?> resolver, Set<String> configuredSubTypes) {
        Class<Enum<?>> subTypeEnum = ConfigurationValidator.getSubTypeEnumReturnedBySubtypeResolver(resolver);
        Set<String> enumSubTypes = Arrays.stream(subTypeEnum.getEnumConstants()).map(Enum::name).collect(Collectors.toSet());
        if (!enumSubTypes.containsAll(configuredSubTypes)) {
            throw SequentialInboxConfigurationException.unknownSubtype(type, configuredSubTypes, enumSubTypes);
        }
        if (!configuredSubTypes.containsAll(enumSubTypes)) {
            throw SequentialInboxConfigurationException.missingSubType(type, configuredSubTypes, enumSubTypes);
        }
    }

    private void validateTypeAndSubtypeNotMixed(Collection<SequencedMessageType> messages) {
        HashSet<String> messageTypesWithSubtype = ConfigurationValidator.messageTypesWithSubtypes(messages);
        Set messageTypesWithoutSubtype = messages.stream().filter(smt -> !ConfigurationValidator.hasSubtype(smt)).map(SequencedMessageType::getJeapMessageTypeName).collect(Collectors.toSet());
        messageTypesWithSubtype.retainAll(messageTypesWithoutSubtype);
        if (!messageTypesWithSubtype.isEmpty()) {
            throw SequentialInboxConfigurationException.mixedTypeAndSubtype(messageTypesWithSubtype);
        }
    }

    private static HashSet<String> messageTypesWithSubtypes(Collection<SequencedMessageType> messages) {
        return messages.stream().filter(ConfigurationValidator::hasSubtype).map(SequencedMessageType::getJeapMessageTypeName).collect(Collectors.toCollection(HashSet::new));
    }

    private static boolean hasSubtype(SequencedMessageType smt) {
        return !smt.getJeapMessageTypeName().equals(smt.getQualifiedName());
    }

    static Class<Enum<?>> getSubTypeEnumReturnedBySubtypeResolver(SubTypeResolver<?, ?> resolver) {
        Type[] genericInterfaces;
        Class enumType = null;
        for (Type genericInterface : genericInterfaces = resolver.getClass().getGenericInterfaces()) {
            Type[] actualTypeArguments;
            ParameterizedType parameterizedType;
            Type rawType;
            if (!(genericInterface instanceof ParameterizedType) || !(rawType = (parameterizedType = (ParameterizedType)genericInterface).getRawType()).getTypeName().equals(SubTypeResolver.class.getName()) || (actualTypeArguments = parameterizedType.getActualTypeArguments()).length <= 1) continue;
            enumType = (Class)actualTypeArguments[1];
            break;
        }
        if (enumType == null || !enumType.isEnum()) {
            throw new IllegalStateException("Unexpected: Unable to resolve enum type from SubTypeResolver");
        }
        return enumType;
    }

    @Generated
    public ConfigurationValidator(List<Sequence> sequences, Map<String, SubTypeResolver<AvroMessage, ?>> subTypeResolvers) {
        this.sequences = sequences;
        this.subTypeResolvers = subTypeResolvers;
    }

    private record TypeWithSubtype(String type, String subType) {
    }
}

