/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.sequentialinbox.inbox;

import ch.admin.bit.jeap.messaging.avro.AvroMessage;
import ch.admin.bit.jeap.messaging.avro.AvroMessageKey;
import ch.admin.bit.jeap.messaging.kafka.errorhandling.ClusterNameHeaderInterceptor;
import ch.admin.bit.jeap.messaging.sequentialinbox.inbox.DeserializedMessage;
import ch.admin.bit.jeap.messaging.sequentialinbox.persistence.BufferedMessage;
import ch.admin.bit.jeap.messaging.sequentialinbox.persistence.SequencedMessage;
import java.util.Optional;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.apache.kafka.common.record.TimestampType;

class FailedConsumerRecord
extends ConsumerRecord<Object, Object> {
    private FailedConsumerRecord(SequencedMessage sequencedMessage, Object key, Object value) {
        super(sequencedMessage.getTopic(), 0, 0L, 0L, TimestampType.NO_TIMESTAMP_TYPE, 0, 0, key, value, FailedConsumerRecord.clusterHeader(sequencedMessage), Optional.empty());
    }

    private static Headers clusterHeader(SequencedMessage sequencedMessage) {
        RecordHeaders headers = new RecordHeaders();
        ClusterNameHeaderInterceptor.addClusterName((Headers)headers, (String)sequencedMessage.getClusterName());
        return headers;
    }

    static FailedConsumerRecord of(SequencedMessage sequencedMessage, AvroMessageKey key, AvroMessage value) {
        return new FailedConsumerRecord(sequencedMessage, key, value);
    }

    static FailedConsumerRecord of(SequencedMessage sequencedMessage, BufferedMessage bufferedMessage) {
        return new FailedConsumerRecord(sequencedMessage, bufferedMessage.getKey(), bufferedMessage.getValue());
    }

    static FailedConsumerRecord of(SequencedMessage sequencedMessage, DeserializedMessage deserializedMessage) {
        return new FailedConsumerRecord(sequencedMessage, deserializedMessage.key(), deserializedMessage.message());
    }
}

