/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.sequentialinbox.housekeeping;

import ch.admin.bit.jeap.messaging.sequentialinbox.jpa.MessageRepository;
import ch.admin.bit.jeap.messaging.sequentialinbox.jpa.SequenceInstanceRepository;
import io.micrometer.core.annotation.Timed;
import java.time.ZonedDateTime;
import lombok.Generated;
import net.javacrumbs.shedlock.spring.annotation.SchedulerLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component
public class SequentialInboxHousekeepingService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SequentialInboxHousekeepingService.class);
    private final MessageRepository messageRepository;
    private final SequenceInstanceRepository sequenceInstanceRepository;

    @Scheduled(cron="${jeap.messaging.sequential-inbox.housekeeping.expiry-cron:0 */15 * * * *}")
    @Transactional(propagation=Propagation.REQUIRES_NEW, isolation=Isolation.REPEATABLE_READ)
    @Timed(value="jeap.messaging.sequential-inbox.housekeeping.expired")
    @SchedulerLock(name="sequential-inbox-housekeeping-expired", lockAtLeastFor="5s", lockAtMostFor="1h")
    public void deleteExpiredMessages() {
        log.debug("Starting housekeeping task: deleting expired messages and sequence instances");
        ZonedDateTime now = ZonedDateTime.now();
        int messagesDeleted = this.messageRepository.deleteExpiredMessages(now);
        int instancesDeleted = this.sequenceInstanceRepository.deleteExpiredInstances(now);
        log.info("Sequential inbox housekeeping task completed: deleted {} expired messages and {} expired sequence instances", (Object)messagesDeleted, (Object)instancesDeleted);
    }

    @Scheduled(cron="${jeap.messaging.sequential-inbox.housekeeping.closed-instances-cron:0 5/15 * * * *}")
    @Transactional(propagation=Propagation.REQUIRES_NEW, isolation=Isolation.REPEATABLE_READ)
    @Timed(value="jeap.messaging.sequential-inbox.housekeeping.closed")
    @SchedulerLock(name="sequential-inbox-housekeeping-closed", lockAtLeastFor="5s", lockAtMostFor="1h")
    public void deleteClosedSequenceInstances() {
        log.debug("Starting housekeeping task: deleting closed sequence instances and related data");
        int messagesDeleted = this.messageRepository.deleteMessagesForClosedSequences();
        int sequenceInstancesDeleted = this.sequenceInstanceRepository.deleteAllClosed();
        log.info("Sequential inbox housekeeping completed: deleted {} messages and {} closed sequence instances", (Object)messagesDeleted, (Object)sequenceInstancesDeleted);
    }

    @Generated
    public SequentialInboxHousekeepingService(MessageRepository messageRepository, SequenceInstanceRepository sequenceInstanceRepository) {
        this.messageRepository = messageRepository;
        this.sequenceInstanceRepository = sequenceInstanceRepository;
    }
}

