/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.sequentialinbox.jpa;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.ZonedDateTime;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.SqlProvider;

record SequenceInstancePreparedStatementCreator(String name, String contextId, String state, ZonedDateTime createdAt, ZonedDateTime retainUntil) implements PreparedStatementCreator,
SqlProvider,
ResultSetExtractor<Long>
{
    private static final String SQL = "INSERT INTO sequence_instance (id, name, context_id, state, created_at, retain_until)\nVALUES (nextval('sequence_instance_sequence'), ?, ?, ?, ?, ?) RETURNING id\n";

    public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
        PreparedStatement ps = con.prepareStatement(SQL);
        ps.setString(1, this.name);
        ps.setString(2, this.contextId);
        ps.setString(3, this.state);
        ps.setObject(4, this.createdAt.toOffsetDateTime());
        ps.setObject(5, this.retainUntil.toOffsetDateTime());
        return ps;
    }

    public String getSql() {
        return SQL;
    }

    public Long extractData(ResultSet rs) throws SQLException, DataAccessException {
        if (rs.next()) {
            return rs.getLong(1);
        }
        throw new IllegalStateException("Insert query failed to return an ID");
    }
}

