/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.sequentialinbox.jpa;

import ch.admin.bit.jeap.messaging.sequentialinbox.jpa.SequenceInstancePreparedStatementCreator;
import ch.admin.bit.jeap.messaging.sequentialinbox.jpa.SpringDataJpaSequenceInstanceRepository;
import ch.admin.bit.jeap.messaging.sequentialinbox.persistence.SequenceInstance;
import jakarta.persistence.EntityManager;
import java.time.ZonedDateTime;
import java.util.Optional;
import lombok.Generated;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional(propagation=Propagation.MANDATORY)
public class SequenceInstanceRepository {
    private final SpringDataJpaSequenceInstanceRepository springDataJpaSequenceInstanceRepository;
    private final EntityManager entityManager;
    private final JdbcTemplate jdbcTemplate;

    @Transactional
    public long saveNewInstance(SequenceInstance sequenceInstance) {
        return this.insertInstance(sequenceInstance.getName(), sequenceInstance.getContextId(), sequenceInstance.getState().name(), sequenceInstance.getCreatedAt(), sequenceInstance.getRetainUntil());
    }

    private long insertInstance(String name, String contextId, String state, ZonedDateTime createdAt, ZonedDateTime retainUntil) {
        SequenceInstancePreparedStatementCreator psc = new SequenceInstancePreparedStatementCreator(name, contextId, state, createdAt, retainUntil);
        return (Long)this.jdbcTemplate.query((PreparedStatementCreator)psc, (ResultSetExtractor)psc);
    }

    public Optional<Long> findIdByNameAndContextId(String name, String contextId) {
        return this.springDataJpaSequenceInstanceRepository.findIdByNameAndContextId(name, contextId);
    }

    public SequenceInstance getByIdAndLockForUpdate(long id, int idleLockTimeoutSeconds) {
        this.setIdleLockTimeoutForCurrentTransaction(idleLockTimeoutSeconds);
        return this.springDataJpaSequenceInstanceRepository.getByIdAndLockForUpdate(id);
    }

    private void setIdleLockTimeoutForCurrentTransaction(int idleLockTimeoutSeconds) {
        if (idleLockTimeoutSeconds < 0) {
            return;
        }
        int millis = idleLockTimeoutSeconds * 1000;
        String queryString = "SET LOCAL idle_in_transaction_session_timeout = '" + millis + "'";
        this.entityManager.createNativeQuery(queryString).executeUpdate();
    }

    @Transactional(propagation=Propagation.MANDATORY)
    public int deleteAllClosed() {
        return this.springDataJpaSequenceInstanceRepository.deleteAllClosed();
    }

    @Transactional(propagation=Propagation.MANDATORY)
    public int deleteExpiredInstances(ZonedDateTime cutoffTime) {
        return this.springDataJpaSequenceInstanceRepository.deleteExpiredInstances(cutoffTime);
    }

    @Generated
    public SequenceInstanceRepository(SpringDataJpaSequenceInstanceRepository springDataJpaSequenceInstanceRepository, EntityManager entityManager, JdbcTemplate jdbcTemplate) {
        this.springDataJpaSequenceInstanceRepository = springDataJpaSequenceInstanceRepository;
        this.entityManager = entityManager;
        this.jdbcTemplate = jdbcTemplate;
    }
}

