/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.sequentialinbox.spring;

import ch.admin.bit.jeap.messaging.avro.AvroMessage;
import ch.admin.bit.jeap.messaging.avro.AvroMessageKey;
import ch.admin.bit.jeap.messaging.sequentialinbox.spring.ListenerBeanMethod;
import ch.admin.bit.jeap.messaging.sequentialinbox.spring.SequentialInboxException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class SequentialInboxMessageHandler {
    private final ListenerBeanMethod listenerBeanMethod;
    private final boolean methodHasKeyParameter;

    SequentialInboxMessageHandler(ListenerBeanMethod listenerBeanMethod, boolean methodHasKeyParameter) {
        this.listenerBeanMethod = listenerBeanMethod;
        this.methodHasKeyParameter = methodHasKeyParameter;
    }

    public void invoke(AvroMessageKey avroMessageKey, AvroMessage message) {
        Method method = this.listenerBeanMethod.method();
        try {
            this.invokeHandlerMethod(avroMessageKey, message, method);
        }
        catch (InvocationTargetException ite) {
            Throwable cause = SequentialInboxMessageHandler.throwCauseIfPossible(ite);
            throw SequentialInboxException.handlerMethodInvocationFailed(method, cause == null ? ite : cause);
        }
        catch (Exception e) {
            throw SequentialInboxException.handlerMethodReflectiveOperationFailed(method, e);
        }
    }

    private static Throwable throwCauseIfPossible(InvocationTargetException ite) {
        Throwable cause = ite.getCause();
        if (cause instanceof RuntimeException) {
            RuntimeException causeEx = (RuntimeException)cause;
            throw causeEx;
        }
        if (cause instanceof Error) {
            Error causeError = (Error)cause;
            throw causeError;
        }
        return cause;
    }

    private void invokeHandlerMethod(AvroMessageKey avroMessageKey, AvroMessage message, Method method) throws IllegalAccessException, InvocationTargetException {
        Object bean = this.listenerBeanMethod.bean();
        if (this.methodHasKeyParameter) {
            method.invoke(bean, avroMessageKey, message);
        } else {
            method.invoke(bean, message);
        }
    }

    ListenerBeanMethod getListenerBeanMethod() {
        return this.listenerBeanMethod;
    }

    public Class<AvroMessage> getMessageTypeClass() {
        return this.listenerBeanMethod.messageTypeClass();
    }

    public String toString() {
        return this.listenerBeanMethod.bean().getClass().getName() + "#" + this.listenerBeanMethod.method().getName() + " key=" + this.methodHasKeyParameter;
    }
}

