/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.sequentialinbox.configuration.deserializer;

import ch.admin.bit.jeap.messaging.sequentialinbox.configuration.deserializer.ContextIdExtractorDeserializer;
import ch.admin.bit.jeap.messaging.sequentialinbox.configuration.deserializer.MessageFilterDeserializer;
import ch.admin.bit.jeap.messaging.sequentialinbox.configuration.deserializer.RetentionPeriodDeserializer;
import ch.admin.bit.jeap.messaging.sequentialinbox.configuration.deserializer.SequentialInboxConfigurationException;
import ch.admin.bit.jeap.messaging.sequentialinbox.configuration.deserializer.SubTypeResolverDeserializer;
import ch.admin.bit.jeap.messaging.sequentialinbox.configuration.model.ContextIdExtractor;
import ch.admin.bit.jeap.messaging.sequentialinbox.configuration.model.MessageFilter;
import ch.admin.bit.jeap.messaging.sequentialinbox.configuration.model.SequentialInboxConfiguration;
import ch.admin.bit.jeap.messaging.sequentialinbox.configuration.model.SubTypeResolver;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class SequentialInboxConfigurationLoader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SequentialInboxConfigurationLoader.class);
    private final String classpathLocation;

    public SequentialInboxConfigurationLoader(String classpathLocation) {
        this.classpathLocation = classpathLocation;
    }

    public SequentialInboxConfiguration loadSequenceDeclaration() {
        log.info("Load Sequential Inbox config from location {}", (Object)this.classpathLocation);
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        mapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.NONE);
        mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        SimpleModule module = new SimpleModule();
        module.addDeserializer(ContextIdExtractor.class, (JsonDeserializer)new ContextIdExtractorDeserializer());
        module.addDeserializer(SubTypeResolver.class, (JsonDeserializer)new SubTypeResolverDeserializer());
        module.addDeserializer(MessageFilter.class, (JsonDeserializer)new MessageFilterDeserializer());
        module.addDeserializer(Duration.class, (JsonDeserializer)new RetentionPeriodDeserializer());
        mapper.registerModule((Module)module);
        SequentialInboxConfiguration sequentialInboxConfiguration = this.readSequentialInboxConfiguration(mapper);
        sequentialInboxConfiguration.validateAndInitialize();
        log.info("Sequential Inbox config loaded with {} sequences", (Object)sequentialInboxConfiguration.getSequenceCount());
        log.debug("Sequential Inbox config: {}", (Object)sequentialInboxConfiguration);
        return sequentialInboxConfiguration;
    }

    private SequentialInboxConfiguration readSequentialInboxConfiguration(ObjectMapper mapper) {
        try {
            return (SequentialInboxConfiguration)mapper.readValue(this.loadConfigurationFileInputStream(), SequentialInboxConfiguration.class);
        }
        catch (IOException e) {
            log.error("Error while reading configuration file {}", (Object)this.classpathLocation, (Object)e);
            throw SequentialInboxConfigurationException.configurationFileParsingError(this.classpathLocation, e);
        }
    }

    private InputStream loadConfigurationFileInputStream() {
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        try {
            return resolver.getResource(this.classpathLocation).getInputStream();
        }
        catch (IOException e) {
            log.error("Error while loading configuration file {}", (Object)this.classpathLocation, (Object)e);
            throw SequentialInboxConfigurationException.configurationFileLoadingError(this.classpathLocation, e);
        }
    }
}

