/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.sequentialinbox.persistence;

import ch.admin.bit.jeap.messaging.sequentialinbox.persistence.MessageHeader;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToMany;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;

@Entity
@Table(name="buffered_message")
public class BufferedMessage {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="bm_sequence")
    @SequenceGenerator(name="bm_sequence", sequenceName="buffered_message_sequence", allocationSize=50)
    @Column(name="id")
    private Long id;
    @Column(name="message_key")
    private byte[] key;
    @Column(name="message_value")
    private byte[] value;
    @Column(name="sequenced_message_id")
    private Long sequencedMessageId;
    @Column(name="sequence_instance_id")
    private long sequenceInstanceId;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="buffered_message_id", referencedColumnName="id")
    private List<MessageHeader> headers = new ArrayList<MessageHeader>();

    private BufferedMessage(long sequenceInstanceId, byte[] key, byte[] value) {
        this.sequenceInstanceId = sequenceInstanceId;
        this.key = key;
        this.value = value;
    }

    public void setHeaders(List<MessageHeader> headers) {
        this.headers.addAll(headers);
    }

    public Map<String, byte[]> getHeaderMap() {
        if (this.headers == null || this.headers.isEmpty()) {
            return Map.of();
        }
        return this.headers.stream().collect(Collectors.toMap(MessageHeader::getHeaderName, MessageHeader::getHeaderValue));
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BufferedMessage that = (BufferedMessage)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hashCode(this.id);
    }

    @Generated
    public static BufferedMessageBuilder builder() {
        return new BufferedMessageBuilder();
    }

    @Generated
    protected BufferedMessage() {
    }

    @Generated
    public String toString() {
        return "BufferedMessage(id=" + this.getId() + ", sequencedMessageId=" + this.getSequencedMessageId() + ", sequenceInstanceId=" + this.getSequenceInstanceId() + ", headers=" + String.valueOf(this.getHeaders()) + ")";
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public byte[] getKey() {
        return this.key;
    }

    @Generated
    public byte[] getValue() {
        return this.value;
    }

    @Generated
    public Long getSequencedMessageId() {
        return this.sequencedMessageId;
    }

    @Generated
    public long getSequenceInstanceId() {
        return this.sequenceInstanceId;
    }

    @Generated
    public List<MessageHeader> getHeaders() {
        return this.headers;
    }

    @Generated
    public void setSequencedMessageId(Long sequencedMessageId) {
        this.sequencedMessageId = sequencedMessageId;
    }

    @Generated
    public static class BufferedMessageBuilder {
        @Generated
        private long sequenceInstanceId;
        @Generated
        private byte[] key;
        @Generated
        private byte[] value;

        @Generated
        BufferedMessageBuilder() {
        }

        @Generated
        public BufferedMessageBuilder sequenceInstanceId(long sequenceInstanceId) {
            this.sequenceInstanceId = sequenceInstanceId;
            return this;
        }

        @Generated
        public BufferedMessageBuilder key(byte[] key) {
            this.key = key;
            return this;
        }

        @Generated
        public BufferedMessageBuilder value(byte[] value) {
            this.value = value;
            return this;
        }

        @Generated
        public BufferedMessage build() {
            return new BufferedMessage(this.sequenceInstanceId, this.key, this.value);
        }

        @Generated
        public String toString() {
            return "BufferedMessage.BufferedMessageBuilder(sequenceInstanceId=" + this.sequenceInstanceId + ", key=" + Arrays.toString(this.key) + ", value=" + Arrays.toString(this.value) + ")";
        }
    }
}

