/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.sequentialinbox.inbox;

import ch.admin.bit.jeap.messaging.kafka.tracing.TraceContext;
import ch.admin.bit.jeap.messaging.kafka.tracing.TraceContextProvider;
import ch.admin.bit.jeap.messaging.kafka.tracing.TraceContextUpdater;
import ch.admin.bit.jeap.messaging.sequentialinbox.persistence.SequentialInboxTraceContext;
import java.io.Closeable;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
class BufferedMessageTracing {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BufferedMessageTracing.class);
    private final Optional<TraceContextUpdater> traceContextUpdaterBean;
    private final Optional<TraceContextProvider> traceContextProvider;

    TraceContextRestorer updateCurrentTraceContext(SequentialInboxTraceContext inboxTraceContext) {
        if (inboxTraceContext == null) {
            return new TraceContextRestorer(null);
        }
        TraceContext originalTraceContext = this.getOriginalTraceContext();
        this.updateTraceContext(inboxTraceContext);
        return new TraceContextRestorer(originalTraceContext);
    }

    private void updateTraceContext(SequentialInboxTraceContext inboxTraceContext) {
        this.traceContextUpdaterBean.ifPresent(traceContextUpdater -> {
            log.debug("Original trace context found on buffered message (traceId={}). Overriding the current tracing context with the tracing context {}", (Object)inboxTraceContext.getTraceIdString(), (Object)inboxTraceContext);
            traceContextUpdater.setTraceContext(BufferedMessageTracing.createTraceContext(inboxTraceContext));
        });
    }

    private TraceContext getOriginalTraceContext() {
        return this.traceContextProvider.map(TraceContextProvider::getTraceContext).orElse(null);
    }

    private static TraceContext createTraceContext(SequentialInboxTraceContext inboxTraceContext) {
        return new TraceContext(inboxTraceContext.getTraceIdHigh(), inboxTraceContext.getTraceId(), inboxTraceContext.getSpanId(), inboxTraceContext.getParentSpanId(), inboxTraceContext.getTraceIdString());
    }

    @Generated
    public BufferedMessageTracing(Optional<TraceContextUpdater> traceContextUpdaterBean, Optional<TraceContextProvider> traceContextProvider) {
        this.traceContextUpdaterBean = traceContextUpdaterBean;
        this.traceContextProvider = traceContextProvider;
    }

    public class TraceContextRestorer
    implements Closeable {
        private final TraceContext traceContextToRestore;

        @Override
        public void close() {
            if (this.traceContextToRestore == null) {
                return;
            }
            BufferedMessageTracing.this.traceContextUpdaterBean.ifPresent(traceContextUpdater -> {
                log.debug("Replacing trace context of buffered message with original trace context with id {}", (Object)this.traceContextToRestore.getTraceId());
                traceContextUpdater.setTraceContext(this.traceContextToRestore);
            });
        }

        @Generated
        public TraceContextRestorer(TraceContext traceContextToRestore) {
            this.traceContextToRestore = traceContextToRestore;
        }
    }
}

