/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.sequentialinbox.configuration.model;

import ch.admin.bit.jeap.messaging.sequentialinbox.configuration.deserializer.SequentialInboxConfigurationException;
import ch.admin.bit.jeap.messaging.sequentialinbox.configuration.model.ReleaseCondition;
import ch.admin.bit.jeap.messaging.sequentialinbox.configuration.model.SequencedMessageType;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ReleaseConditionsValidator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReleaseConditionsValidator.class);
    private final List<SequencedMessageType> messages;
    private Set<String> currentCheckedMessageTypes = new HashSet<String>();
    private String currentMessageType;

    void validate() {
        this.messages.stream().filter(m -> m.getReleaseCondition() != null).forEach(message -> {
            log.info("Checking release conditions for message type: {}", (Object)message.getQualifiedName());
            if (!message.getReleaseCondition().getAnd().isEmpty() && !message.getReleaseCondition().getOr().isEmpty()) {
                throw SequentialInboxConfigurationException.invalidPredecessorConfiguration(message.getQualifiedName());
            }
            if (message.getReleaseCondition().getPredecessor() == null ? message.getReleaseCondition().getAnd().isEmpty() && message.getReleaseCondition().getOr().isEmpty() : !message.getReleaseCondition().getAnd().isEmpty() || !message.getReleaseCondition().getOr().isEmpty()) {
                throw SequentialInboxConfigurationException.invalidPredecessorConfiguration(message.getQualifiedName());
            }
            this.currentCheckedMessageTypes = new HashSet<String>();
            this.currentMessageType = message.getQualifiedName();
            this.validate(message.getQualifiedName(), message.getReleaseCondition());
            log.info("Release conditions for {} are valid : {}", (Object)this.currentMessageType, this.currentCheckedMessageTypes.stream().sorted().toList());
        });
    }

    private void validate(String parent, ReleaseCondition releaseCondition) {
        if (releaseCondition == null) {
            return;
        }
        if (releaseCondition.getPredecessor() != null && releaseCondition.getPredecessor().equals(this.currentMessageType)) {
            throw SequentialInboxConfigurationException.circularPredecessorDefinition(this.currentMessageType, parent);
        }
        if (releaseCondition.getPredecessor() != null) {
            SequencedMessageType predecessor = this.getPredecessorMessageType(releaseCondition.getPredecessor());
            if (predecessor.getQualifiedName().equals(this.currentMessageType)) {
                throw SequentialInboxConfigurationException.circularPredecessorDefinition(this.currentMessageType, parent);
            }
            if (!this.currentCheckedMessageTypes.add(predecessor.getQualifiedName())) {
                return;
            }
            this.validate(predecessor.getQualifiedName(), predecessor.getReleaseCondition());
        }
        if (releaseCondition.getAnd().size() == 1 || releaseCondition.getOr().size() == 1) {
            throw SequentialInboxConfigurationException.invalidPredecessorConfiguration(parent);
        }
        this.checkDuplicatesInOperation(parent, releaseCondition.getAnd());
        this.checkDuplicatesInOperation(parent, releaseCondition.getOr());
        releaseCondition.getAnd().forEach(current -> this.validate(parent, (ReleaseCondition)current));
        releaseCondition.getOr().forEach(current -> this.validate(parent, (ReleaseCondition)current));
    }

    private SequencedMessageType getPredecessorMessageType(String messageTypeQualifiedName) {
        return this.messages.stream().filter(m -> m.getQualifiedName().equals(messageTypeQualifiedName)).findFirst().orElseThrow(() -> SequentialInboxConfigurationException.predecessorNotFound(messageTypeQualifiedName));
    }

    private void checkDuplicatesInOperation(String parent, List<ReleaseCondition> releaseConditions) {
        List<ReleaseCondition> list = releaseConditions.stream().filter(current -> current.getPredecessor() != null).toList();
        if ((long)list.size() != list.stream().map(ReleaseCondition::getPredecessor).distinct().count()) {
            throw SequentialInboxConfigurationException.duplicatedPredecessor(parent);
        }
    }

    @Generated
    public ReleaseConditionsValidator(List<SequencedMessageType> messages) {
        this.messages = messages;
    }
}

