/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.sequentialinbox.persistence;

import ch.admin.bit.jeap.messaging.sequentialinbox.persistence.SequencedMessageState;
import ch.admin.bit.jeap.messaging.sequentialinbox.persistence.SequentialInboxTraceContext;
import jakarta.persistence.Column;
import jakarta.persistence.Embedded;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.UUID;
import lombok.Generated;

@Entity
@Table(name="sequenced_message")
public class SequencedMessage {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="sm_sequence")
    @SequenceGenerator(name="sm_sequence", sequenceName="sequenced_message_sequence", allocationSize=50)
    @Column(name="id")
    private Long id;
    @Column(name="message_type")
    private String messageType;
    @Column(name="sequenced_message_id")
    private UUID sequencedMessageId;
    @Column(name="idempotence_id")
    private String idempotenceId;
    @Column(name="cluster_name")
    private String clusterName;
    @Column(name="topic")
    private String topic;
    @Column(name="state")
    @Enumerated(value=EnumType.STRING)
    private SequencedMessageState state;
    @Embedded
    private SequentialInboxTraceContext traceContext;
    @Column(name="created_at")
    private ZonedDateTime createdAt;
    @Column(name="state_changed_at")
    private ZonedDateTime stateChangedAt;
    @Column(name="sequence_instance_id")
    private long sequenceInstanceId;

    private SequencedMessage(long sequenceInstanceId, String messageType, UUID sequencedMessageId, String idempotenceId, String clusterName, String topic, SequencedMessageState state, SequentialInboxTraceContext traceContext) {
        this.messageType = messageType;
        this.sequencedMessageId = sequencedMessageId;
        this.idempotenceId = idempotenceId;
        this.clusterName = clusterName;
        this.topic = topic;
        this.state = state;
        this.traceContext = traceContext;
        this.createdAt = ZonedDateTime.now();
        this.sequenceInstanceId = sequenceInstanceId;
    }

    public String toString() {
        return "SequencedMessage{id=" + this.id + ", messageType='" + this.messageType + "', sequencedMessageId=" + String.valueOf(this.sequencedMessageId) + ", idempotenceId='" + this.idempotenceId + "', state=" + String.valueOf((Object)this.state) + ", sequenceInstanceId=" + this.sequenceInstanceId + "}";
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SequencedMessage that = (SequencedMessage)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hashCode(this.id);
    }

    @Generated
    public static SequencedMessageBuilder builder() {
        return new SequencedMessageBuilder();
    }

    @Generated
    protected SequencedMessage() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getMessageType() {
        return this.messageType;
    }

    @Generated
    public UUID getSequencedMessageId() {
        return this.sequencedMessageId;
    }

    @Generated
    public String getIdempotenceId() {
        return this.idempotenceId;
    }

    @Generated
    public String getClusterName() {
        return this.clusterName;
    }

    @Generated
    public String getTopic() {
        return this.topic;
    }

    @Generated
    public SequencedMessageState getState() {
        return this.state;
    }

    @Generated
    public SequentialInboxTraceContext getTraceContext() {
        return this.traceContext;
    }

    @Generated
    public ZonedDateTime getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public ZonedDateTime getStateChangedAt() {
        return this.stateChangedAt;
    }

    @Generated
    public long getSequenceInstanceId() {
        return this.sequenceInstanceId;
    }

    @Generated
    public void setState(SequencedMessageState state) {
        this.state = state;
    }

    @Generated
    public static class SequencedMessageBuilder {
        @Generated
        private long sequenceInstanceId;
        @Generated
        private String messageType;
        @Generated
        private UUID sequencedMessageId;
        @Generated
        private String idempotenceId;
        @Generated
        private String clusterName;
        @Generated
        private String topic;
        @Generated
        private SequencedMessageState state;
        @Generated
        private SequentialInboxTraceContext traceContext;

        @Generated
        SequencedMessageBuilder() {
        }

        @Generated
        public SequencedMessageBuilder sequenceInstanceId(long sequenceInstanceId) {
            this.sequenceInstanceId = sequenceInstanceId;
            return this;
        }

        @Generated
        public SequencedMessageBuilder messageType(String messageType) {
            this.messageType = messageType;
            return this;
        }

        @Generated
        public SequencedMessageBuilder sequencedMessageId(UUID sequencedMessageId) {
            this.sequencedMessageId = sequencedMessageId;
            return this;
        }

        @Generated
        public SequencedMessageBuilder idempotenceId(String idempotenceId) {
            this.idempotenceId = idempotenceId;
            return this;
        }

        @Generated
        public SequencedMessageBuilder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        @Generated
        public SequencedMessageBuilder topic(String topic) {
            this.topic = topic;
            return this;
        }

        @Generated
        public SequencedMessageBuilder state(SequencedMessageState state) {
            this.state = state;
            return this;
        }

        @Generated
        public SequencedMessageBuilder traceContext(SequentialInboxTraceContext traceContext) {
            this.traceContext = traceContext;
            return this;
        }

        @Generated
        public SequencedMessage build() {
            return new SequencedMessage(this.sequenceInstanceId, this.messageType, this.sequencedMessageId, this.idempotenceId, this.clusterName, this.topic, this.state, this.traceContext);
        }

        @Generated
        public String toString() {
            return "SequencedMessage.SequencedMessageBuilder(sequenceInstanceId=" + this.sequenceInstanceId + ", messageType=" + this.messageType + ", sequencedMessageId=" + String.valueOf(this.sequencedMessageId) + ", idempotenceId=" + this.idempotenceId + ", clusterName=" + this.clusterName + ", topic=" + this.topic + ", state=" + String.valueOf((Object)this.state) + ", traceContext=" + String.valueOf(this.traceContext) + ")";
        }
    }
}

