/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.sequentialinbox.metrics;

import ch.admin.bit.jeap.messaging.sequentialinbox.jpa.MessageRepository;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

class SequentialInboxPersistenceMetrics {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SequentialInboxPersistenceMetrics.class);
    private final MessageRepository messageRepository;
    private final Map<String, Double> waitingMessageCountByType = new ConcurrentHashMap<String, Double>();

    @Transactional
    public void updateMetrics() {
        log.debug("Updating scheduled inbox metrics");
        this.waitingMessageCountByType.putAll(this.messageRepository.getWaitingMessageCountByType());
    }

    public double getWaitingMessagesOfType(String type) {
        return this.waitingMessageCountByType.getOrDefault(type, 0.0);
    }

    @Generated
    public SequentialInboxPersistenceMetrics(MessageRepository messageRepository) {
        this.messageRepository = messageRepository;
    }
}

