/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.sequentialinbox.jpa;

import ch.admin.bit.jeap.messaging.sequentialinbox.jpa.CountByType;
import ch.admin.bit.jeap.messaging.sequentialinbox.persistence.SequencedMessage;
import ch.admin.bit.jeap.messaging.sequentialinbox.persistence.SequencedMessageState;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

@Repository
interface SpringDataJpaSequencedMessageRepository
extends JpaRepository<SequencedMessage, Long> {
    @Query(nativeQuery=true, value="SELECT message_type FROM sequenced_message WHERE sequence_instance_id = ?1 AND state = 'PROCESSED'")
    public Set<String> getProcessedMessageTypesInSequence(Long var1);

    public List<SequencedMessage> findAllBySequenceInstanceIdAndStateIn(long var1, Set<SequencedMessageState> var3);

    @Modifying
    @Query(nativeQuery=true, value="UPDATE sequenced_message SET state = ?2, state_changed_at = NOW() WHERE id = ?1")
    public void updateStateById(long var1, String var3);

    public Optional<SequencedMessage> findByMessageTypeAndIdempotenceId(String var1, String var2);

    @Modifying
    @Query(nativeQuery=true, value="DELETE FROM sequenced_message WHERE sequence_instance_id IN (SELECT id FROM sequence_instance WHERE retain_until < ?1)")
    public int deleteExpired(ZonedDateTime var1);

    @Modifying
    @Query(nativeQuery=true, value="DELETE FROM sequenced_message WHERE sequence_instance_id IN (SELECT id FROM sequence_instance WHERE state = 'CLOSED')")
    public int deleteForClosedSequences();

    @Query(nativeQuery=true, value="SELECT message_type as messageType, COUNT(*) as stateCount FROM sequenced_message WHERE state = 'WAITING' GROUP BY message_type")
    public List<CountByType> getWaitingMessageCountGroupedByMessageType();
}

