/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.oauth.mock.server.config;

import ch.admin.bit.jeap.oauth.mock.server.config.ClientData;
import jakarta.annotation.PostConstruct;
import jakarta.validation.constraints.NotEmpty;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.validation.annotation.Validated;

@Configuration
@ConfigurationProperties(prefix="oauth-mock-data")
@Validated
public class OAuthMockData {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OAuthMockData.class);
    private static final List<String> DEFAULT_GRANT_TYPES = Arrays.asList("authorization_code", "client_credentials", "refresh_token");
    @NotEmpty(message="at least one oauth client definition is required")
    @NestedConfigurationProperty
    private @NotEmpty(message="at least one oauth client definition is required") List<ClientData> clients = Collections.emptyList();
    @NestedConfigurationProperty
    private List<UserData> users = Collections.emptyList();

    @Bean
    public Map<String, RegisteredClient> clientsById() {
        return this.clients.stream().collect(Collectors.toMap(ClientData::getClientId, ClientData::toRegisteredClient));
    }

    @Bean
    public Map<String, UserData> usersById() {
        return this.users.stream().collect(Collectors.toMap(UserData::getId, Function.identity()));
    }

    @Bean
    List<UserData> users() {
        return this.users;
    }

    @PostConstruct
    void validateConfig() {
        this.clients.forEach(clientData -> log.info("Adding client from configuration: {}", (Object)clientData.getClientId()));
        this.users.forEach(userData -> log.info("Adding User from configuration: {} ({})", (Object)userData.getId(), (Object)userData.getName()));
    }

    @Generated
    public OAuthMockData() {
    }

    @Generated
    public List<ClientData> getClients() {
        return this.clients;
    }

    @Generated
    public List<UserData> getUsers() {
        return this.users;
    }

    @Generated
    public void setClients(List<ClientData> clients) {
        this.clients = clients;
    }

    @Generated
    public void setUsers(List<UserData> users) {
        this.users = users;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OAuthMockData)) {
            return false;
        }
        OAuthMockData other = (OAuthMockData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<ClientData> this$clients = this.getClients();
        List<ClientData> other$clients = other.getClients();
        if (this$clients == null ? other$clients != null : !((Object)this$clients).equals(other$clients)) {
            return false;
        }
        List<UserData> this$users = this.getUsers();
        List<UserData> other$users = other.getUsers();
        return !(this$users == null ? other$users != null : !((Object)this$users).equals(other$users));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OAuthMockData;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<ClientData> $clients = this.getClients();
        result = result * 59 + ($clients == null ? 43 : ((Object)$clients).hashCode());
        List<UserData> $users = this.getUsers();
        result = result * 59 + ($users == null ? 43 : ((Object)$users).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "OAuthMockData(clients=" + String.valueOf(this.getClients()) + ", users=" + String.valueOf(this.getUsers()) + ")";
    }

    public static class UserData {
        @NotEmpty
        private String id;
        private String givenName;
        private String familyName;
        private String email;
        private String locale;
        private String preferredUsername;
        private String extId;
        private String adminDirUID;
        private String loginLevel;
        private String subject;
        private List<String> userroles;
        private Map<String, List<String>> bproles;
        private Map<String, Object> additionalClaims;

        public String getName() {
            return this.givenName + " " + this.familyName;
        }

        @Generated
        private static String $default$givenName() {
            return "Henriette";
        }

        @Generated
        private static String $default$familyName() {
            return "Muster";
        }

        @Generated
        private static String $default$email() {
            return "henriette@muster.domain";
        }

        @Generated
        private static String $default$locale() {
            return "DE";
        }

        @Generated
        private static String $default$preferredUsername() {
            return "1234";
        }

        @Generated
        private static String $default$extId() {
            return "5678";
        }

        @Generated
        private static String $default$adminDirUID() {
            return "U11111111";
        }

        @Generated
        private static String $default$loginLevel() {
            return "S0";
        }

        @Generated
        private static List<String> $default$userroles() {
            return Collections.emptyList();
        }

        @Generated
        private static Map<String, List<String>> $default$bproles() {
            return Collections.emptyMap();
        }

        @Generated
        private static Map<String, Object> $default$additionalClaims() {
            return Collections.emptyMap();
        }

        @Generated
        public static UserDataBuilder builder() {
            return new UserDataBuilder();
        }

        @Generated
        public UserDataBuilder toBuilder() {
            return new UserDataBuilder().id(this.id).givenName(this.givenName).familyName(this.familyName).email(this.email).locale(this.locale).preferredUsername(this.preferredUsername).extId(this.extId).adminDirUID(this.adminDirUID).loginLevel(this.loginLevel).subject(this.subject).userroles(this.userroles).bproles(this.bproles).additionalClaims(this.additionalClaims);
        }

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public String getGivenName() {
            return this.givenName;
        }

        @Generated
        public String getFamilyName() {
            return this.familyName;
        }

        @Generated
        public String getEmail() {
            return this.email;
        }

        @Generated
        public String getLocale() {
            return this.locale;
        }

        @Generated
        public String getPreferredUsername() {
            return this.preferredUsername;
        }

        @Generated
        public String getExtId() {
            return this.extId;
        }

        @Generated
        public String getAdminDirUID() {
            return this.adminDirUID;
        }

        @Generated
        public String getLoginLevel() {
            return this.loginLevel;
        }

        @Generated
        public String getSubject() {
            return this.subject;
        }

        @Generated
        public List<String> getUserroles() {
            return this.userroles;
        }

        @Generated
        public Map<String, List<String>> getBproles() {
            return this.bproles;
        }

        @Generated
        public Map<String, Object> getAdditionalClaims() {
            return this.additionalClaims;
        }

        @Generated
        public void setId(String id) {
            this.id = id;
        }

        @Generated
        public void setGivenName(String givenName) {
            this.givenName = givenName;
        }

        @Generated
        public void setFamilyName(String familyName) {
            this.familyName = familyName;
        }

        @Generated
        public void setEmail(String email) {
            this.email = email;
        }

        @Generated
        public void setLocale(String locale) {
            this.locale = locale;
        }

        @Generated
        public void setPreferredUsername(String preferredUsername) {
            this.preferredUsername = preferredUsername;
        }

        @Generated
        public void setExtId(String extId) {
            this.extId = extId;
        }

        @Generated
        public void setAdminDirUID(String adminDirUID) {
            this.adminDirUID = adminDirUID;
        }

        @Generated
        public void setLoginLevel(String loginLevel) {
            this.loginLevel = loginLevel;
        }

        @Generated
        public void setSubject(String subject) {
            this.subject = subject;
        }

        @Generated
        public void setUserroles(List<String> userroles) {
            this.userroles = userroles;
        }

        @Generated
        public void setBproles(Map<String, List<String>> bproles) {
            this.bproles = bproles;
        }

        @Generated
        public void setAdditionalClaims(Map<String, Object> additionalClaims) {
            this.additionalClaims = additionalClaims;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UserData)) {
                return false;
            }
            UserData other = (UserData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$givenName = this.getGivenName();
            String other$givenName = other.getGivenName();
            if (this$givenName == null ? other$givenName != null : !this$givenName.equals(other$givenName)) {
                return false;
            }
            String this$familyName = this.getFamilyName();
            String other$familyName = other.getFamilyName();
            if (this$familyName == null ? other$familyName != null : !this$familyName.equals(other$familyName)) {
                return false;
            }
            String this$email = this.getEmail();
            String other$email = other.getEmail();
            if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
                return false;
            }
            String this$locale = this.getLocale();
            String other$locale = other.getLocale();
            if (this$locale == null ? other$locale != null : !this$locale.equals(other$locale)) {
                return false;
            }
            String this$preferredUsername = this.getPreferredUsername();
            String other$preferredUsername = other.getPreferredUsername();
            if (this$preferredUsername == null ? other$preferredUsername != null : !this$preferredUsername.equals(other$preferredUsername)) {
                return false;
            }
            String this$extId = this.getExtId();
            String other$extId = other.getExtId();
            if (this$extId == null ? other$extId != null : !this$extId.equals(other$extId)) {
                return false;
            }
            String this$adminDirUID = this.getAdminDirUID();
            String other$adminDirUID = other.getAdminDirUID();
            if (this$adminDirUID == null ? other$adminDirUID != null : !this$adminDirUID.equals(other$adminDirUID)) {
                return false;
            }
            String this$loginLevel = this.getLoginLevel();
            String other$loginLevel = other.getLoginLevel();
            if (this$loginLevel == null ? other$loginLevel != null : !this$loginLevel.equals(other$loginLevel)) {
                return false;
            }
            String this$subject = this.getSubject();
            String other$subject = other.getSubject();
            if (this$subject == null ? other$subject != null : !this$subject.equals(other$subject)) {
                return false;
            }
            List<String> this$userroles = this.getUserroles();
            List<String> other$userroles = other.getUserroles();
            if (this$userroles == null ? other$userroles != null : !((Object)this$userroles).equals(other$userroles)) {
                return false;
            }
            Map<String, List<String>> this$bproles = this.getBproles();
            Map<String, List<String>> other$bproles = other.getBproles();
            if (this$bproles == null ? other$bproles != null : !((Object)this$bproles).equals(other$bproles)) {
                return false;
            }
            Map<String, Object> this$additionalClaims = this.getAdditionalClaims();
            Map<String, Object> other$additionalClaims = other.getAdditionalClaims();
            return !(this$additionalClaims == null ? other$additionalClaims != null : !((Object)this$additionalClaims).equals(other$additionalClaims));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof UserData;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $givenName = this.getGivenName();
            result = result * 59 + ($givenName == null ? 43 : $givenName.hashCode());
            String $familyName = this.getFamilyName();
            result = result * 59 + ($familyName == null ? 43 : $familyName.hashCode());
            String $email = this.getEmail();
            result = result * 59 + ($email == null ? 43 : $email.hashCode());
            String $locale = this.getLocale();
            result = result * 59 + ($locale == null ? 43 : $locale.hashCode());
            String $preferredUsername = this.getPreferredUsername();
            result = result * 59 + ($preferredUsername == null ? 43 : $preferredUsername.hashCode());
            String $extId = this.getExtId();
            result = result * 59 + ($extId == null ? 43 : $extId.hashCode());
            String $adminDirUID = this.getAdminDirUID();
            result = result * 59 + ($adminDirUID == null ? 43 : $adminDirUID.hashCode());
            String $loginLevel = this.getLoginLevel();
            result = result * 59 + ($loginLevel == null ? 43 : $loginLevel.hashCode());
            String $subject = this.getSubject();
            result = result * 59 + ($subject == null ? 43 : $subject.hashCode());
            List<String> $userroles = this.getUserroles();
            result = result * 59 + ($userroles == null ? 43 : ((Object)$userroles).hashCode());
            Map<String, List<String>> $bproles = this.getBproles();
            result = result * 59 + ($bproles == null ? 43 : ((Object)$bproles).hashCode());
            Map<String, Object> $additionalClaims = this.getAdditionalClaims();
            result = result * 59 + ($additionalClaims == null ? 43 : ((Object)$additionalClaims).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "OAuthMockData.UserData(id=" + this.getId() + ", givenName=" + this.getGivenName() + ", familyName=" + this.getFamilyName() + ", email=" + this.getEmail() + ", locale=" + this.getLocale() + ", preferredUsername=" + this.getPreferredUsername() + ", extId=" + this.getExtId() + ", adminDirUID=" + this.getAdminDirUID() + ", loginLevel=" + this.getLoginLevel() + ", subject=" + this.getSubject() + ", userroles=" + String.valueOf(this.getUserroles()) + ", bproles=" + String.valueOf(this.getBproles()) + ", additionalClaims=" + String.valueOf(this.getAdditionalClaims()) + ")";
        }

        @Generated
        public UserData() {
            this.givenName = UserData.$default$givenName();
            this.familyName = UserData.$default$familyName();
            this.email = UserData.$default$email();
            this.locale = UserData.$default$locale();
            this.preferredUsername = UserData.$default$preferredUsername();
            this.extId = UserData.$default$extId();
            this.adminDirUID = UserData.$default$adminDirUID();
            this.loginLevel = UserData.$default$loginLevel();
            this.userroles = UserData.$default$userroles();
            this.bproles = UserData.$default$bproles();
            this.additionalClaims = UserData.$default$additionalClaims();
        }

        @Generated
        public UserData(String id, String givenName, String familyName, String email, String locale, String preferredUsername, String extId, String adminDirUID, String loginLevel, String subject, List<String> userroles, Map<String, List<String>> bproles, Map<String, Object> additionalClaims) {
            this.id = id;
            this.givenName = givenName;
            this.familyName = familyName;
            this.email = email;
            this.locale = locale;
            this.preferredUsername = preferredUsername;
            this.extId = extId;
            this.adminDirUID = adminDirUID;
            this.loginLevel = loginLevel;
            this.subject = subject;
            this.userroles = userroles;
            this.bproles = bproles;
            this.additionalClaims = additionalClaims;
        }

        @Generated
        public static class UserDataBuilder {
            @Generated
            private String id;
            @Generated
            private boolean givenName$set;
            @Generated
            private String givenName$value;
            @Generated
            private boolean familyName$set;
            @Generated
            private String familyName$value;
            @Generated
            private boolean email$set;
            @Generated
            private String email$value;
            @Generated
            private boolean locale$set;
            @Generated
            private String locale$value;
            @Generated
            private boolean preferredUsername$set;
            @Generated
            private String preferredUsername$value;
            @Generated
            private boolean extId$set;
            @Generated
            private String extId$value;
            @Generated
            private boolean adminDirUID$set;
            @Generated
            private String adminDirUID$value;
            @Generated
            private boolean loginLevel$set;
            @Generated
            private String loginLevel$value;
            @Generated
            private String subject;
            @Generated
            private boolean userroles$set;
            @Generated
            private List<String> userroles$value;
            @Generated
            private boolean bproles$set;
            @Generated
            private Map<String, List<String>> bproles$value;
            @Generated
            private boolean additionalClaims$set;
            @Generated
            private Map<String, Object> additionalClaims$value;

            @Generated
            UserDataBuilder() {
            }

            @Generated
            public UserDataBuilder id(String id) {
                this.id = id;
                return this;
            }

            @Generated
            public UserDataBuilder givenName(String givenName) {
                this.givenName$value = givenName;
                this.givenName$set = true;
                return this;
            }

            @Generated
            public UserDataBuilder familyName(String familyName) {
                this.familyName$value = familyName;
                this.familyName$set = true;
                return this;
            }

            @Generated
            public UserDataBuilder email(String email) {
                this.email$value = email;
                this.email$set = true;
                return this;
            }

            @Generated
            public UserDataBuilder locale(String locale) {
                this.locale$value = locale;
                this.locale$set = true;
                return this;
            }

            @Generated
            public UserDataBuilder preferredUsername(String preferredUsername) {
                this.preferredUsername$value = preferredUsername;
                this.preferredUsername$set = true;
                return this;
            }

            @Generated
            public UserDataBuilder extId(String extId) {
                this.extId$value = extId;
                this.extId$set = true;
                return this;
            }

            @Generated
            public UserDataBuilder adminDirUID(String adminDirUID) {
                this.adminDirUID$value = adminDirUID;
                this.adminDirUID$set = true;
                return this;
            }

            @Generated
            public UserDataBuilder loginLevel(String loginLevel) {
                this.loginLevel$value = loginLevel;
                this.loginLevel$set = true;
                return this;
            }

            @Generated
            public UserDataBuilder subject(String subject) {
                this.subject = subject;
                return this;
            }

            @Generated
            public UserDataBuilder userroles(List<String> userroles) {
                this.userroles$value = userroles;
                this.userroles$set = true;
                return this;
            }

            @Generated
            public UserDataBuilder bproles(Map<String, List<String>> bproles) {
                this.bproles$value = bproles;
                this.bproles$set = true;
                return this;
            }

            @Generated
            public UserDataBuilder additionalClaims(Map<String, Object> additionalClaims) {
                this.additionalClaims$value = additionalClaims;
                this.additionalClaims$set = true;
                return this;
            }

            @Generated
            public UserData build() {
                String givenName$value = this.givenName$value;
                if (!this.givenName$set) {
                    givenName$value = UserData.$default$givenName();
                }
                String familyName$value = this.familyName$value;
                if (!this.familyName$set) {
                    familyName$value = UserData.$default$familyName();
                }
                String email$value = this.email$value;
                if (!this.email$set) {
                    email$value = UserData.$default$email();
                }
                String locale$value = this.locale$value;
                if (!this.locale$set) {
                    locale$value = UserData.$default$locale();
                }
                String preferredUsername$value = this.preferredUsername$value;
                if (!this.preferredUsername$set) {
                    preferredUsername$value = UserData.$default$preferredUsername();
                }
                String extId$value = this.extId$value;
                if (!this.extId$set) {
                    extId$value = UserData.$default$extId();
                }
                String adminDirUID$value = this.adminDirUID$value;
                if (!this.adminDirUID$set) {
                    adminDirUID$value = UserData.$default$adminDirUID();
                }
                String loginLevel$value = this.loginLevel$value;
                if (!this.loginLevel$set) {
                    loginLevel$value = UserData.$default$loginLevel();
                }
                List<String> userroles$value = this.userroles$value;
                if (!this.userroles$set) {
                    userroles$value = UserData.$default$userroles();
                }
                Map<String, List<String>> bproles$value = this.bproles$value;
                if (!this.bproles$set) {
                    bproles$value = UserData.$default$bproles();
                }
                Map<String, Object> additionalClaims$value = this.additionalClaims$value;
                if (!this.additionalClaims$set) {
                    additionalClaims$value = UserData.$default$additionalClaims();
                }
                return new UserData(this.id, givenName$value, familyName$value, email$value, locale$value, preferredUsername$value, extId$value, adminDirUID$value, loginLevel$value, this.subject, userroles$value, bproles$value, additionalClaims$value);
            }

            @Generated
            public String toString() {
                return "OAuthMockData.UserData.UserDataBuilder(id=" + this.id + ", givenName$value=" + this.givenName$value + ", familyName$value=" + this.familyName$value + ", email$value=" + this.email$value + ", locale$value=" + this.locale$value + ", preferredUsername$value=" + this.preferredUsername$value + ", extId$value=" + this.extId$value + ", adminDirUID$value=" + this.adminDirUID$value + ", loginLevel$value=" + this.loginLevel$value + ", subject=" + this.subject + ", userroles$value=" + String.valueOf(this.userroles$value) + ", bproles$value=" + String.valueOf(this.bproles$value) + ", additionalClaims$value=" + String.valueOf(this.additionalClaims$value) + ")";
            }
        }
    }
}

