/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.oauth.mock.server.login;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.filter.GenericFilterBean;

public class ForceLoginFormFilter
extends GenericFilterBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ForceLoginFormFilter.class);

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        filterChain.doFilter(servletRequest, servletResponse);
        String redirectUrl = this.getRedirectUrl((HttpServletResponse)servletResponse);
        if (this.isTokenGrantRedirect(redirectUrl)) {
            this.invalidateSession((HttpServletRequest)servletRequest);
        }
    }

    private String getRedirectUrl(HttpServletResponse response) {
        if (response.getStatus() >= 300 && response.getStatus() < 400) {
            return response.getHeader("Location");
        }
        return null;
    }

    private boolean isTokenGrantRedirect(String url) {
        return url != null && (url.contains("code=") || url.contains("error="));
    }

    private void invalidateSession(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session != null) {
            log.info("Login succeeded, clearing HTTP session");
            session.invalidate();
        }
    }
}

