/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.oauth.mock.server.security;

import com.nimbusds.jose.jwk.JWKMatcher;
import com.nimbusds.jose.jwk.JWKSelector;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.proc.SecurityContext;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
public class KeycloakLikeCertEndpointRedirectController {
    private final JWKSource<SecurityContext> jwkSource;
    private final JWKSelector jwkSelector;

    public KeycloakLikeCertEndpointRedirectController(JWKSource<SecurityContext> jwkSource) {
        this.jwkSource = jwkSource;
        this.jwkSelector = new JWKSelector(new JWKMatcher.Builder().build());
    }

    @GetMapping(value={"/protocol/openid-connect/certs"})
    public void returnJwkSetAtKeycloakCompatibleResourcePath(HttpServletResponse response) throws IOException {
        JWKSet jwkSet = this.getJwkSet();
        response.setContentType("application/json");
        try (PrintWriter writer = response.getWriter();){
            ((Writer)writer).write(jwkSet.toString());
        }
    }

    private JWKSet getJwkSet() {
        try {
            return new JWKSet(this.jwkSource.get(this.jwkSelector, null));
        }
        catch (Exception ex) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, "Failed to select the JWK(s) -> " + ex.getMessage(), (Throwable)ex);
        }
    }
}

