/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.oauth.mock.server.token;

import ch.admin.bit.jeap.oauth.mock.server.config.OAuthMockData;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.server.authorization.OAuth2TokenType;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.security.oauth2.server.authorization.token.JwtEncodingContext;
import org.springframework.security.oauth2.server.authorization.token.OAuth2TokenCustomizer;

public abstract class AbstractJwtTokenCustomizer
implements OAuth2TokenCustomizer<JwtEncodingContext> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractJwtTokenCustomizer.class);
    private Map<String, RegisteredClient> clientsById;
    private Map<String, OAuthMockData.UserData> usersById;

    @Autowired
    public final void setClientsById(Map<String, RegisteredClient> clientsById) {
        this.clientsById = clientsById;
    }

    @Autowired
    public final void setUsersById(Map<String, OAuthMockData.UserData> usersById) {
        this.usersById = usersById;
    }

    public void customize(JwtEncodingContext context) {
        context.getClaims().claims(claims -> {
            if (AbstractJwtTokenCustomizer.isAccessToken(context)) {
                this.customizeAccessToken(context, (Map<String, Object>)claims);
            }
            if (AbstractJwtTokenCustomizer.isIdToken(context)) {
                this.customizeIdToken(context, (Map<String, Object>)claims);
            }
        });
    }

    protected abstract void customizeAccessToken(JwtEncodingContext var1, Map<String, Object> var2);

    protected abstract void customizeIdToken(JwtEncodingContext var1, Map<String, Object> var2);

    protected static boolean isAccessToken(JwtEncodingContext context) {
        return context.getTokenType().getValue().equals(OAuth2TokenType.ACCESS_TOKEN.getValue());
    }

    protected static boolean isIdToken(JwtEncodingContext context) {
        return context.getTokenType().getValue().equals("id_token");
    }

    protected RegisteredClient requireClient(String clientId) {
        RegisteredClient registeredClient = this.clientsById.get(clientId);
        if (registeredClient == null) {
            throw AbstractJwtTokenCustomizer.unknownClientException(clientId);
        }
        return registeredClient;
    }

    protected OAuthMockData.UserData requireUser(String name) {
        OAuthMockData.UserData userData = this.usersById.get(name);
        if (userData == null) {
            throw AbstractJwtTokenCustomizer.unknownUserException(name);
        }
        return userData;
    }

    protected static String getClientIdFromSecurityContext() {
        Object principal = SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        if (principal instanceof User) {
            return ((User)principal).getUsername();
        }
        return principal.toString();
    }

    protected void addAdditionalUserClaims(OAuthMockData.UserData userData, Map<String, Object> claims) {
        if (userData == null || userData.getAdditionalClaims() == null) {
            return;
        }
        for (Map.Entry<String, Object> entry : userData.getAdditionalClaims().entrySet()) {
            if (entry.getValue() == null) continue;
            claims.put(entry.getKey(), entry.getValue());
        }
    }

    private static OAuth2AuthenticationException unknownClientException(String clientId) {
        String msg = "Unknown client: " + clientId;
        log.error(msg);
        return new OAuth2AuthenticationException(new OAuth2Error("invalid_client"), msg);
    }

    private static OAuth2AuthenticationException unknownUserException(String username) {
        String msg = "Unknown user: " + username;
        log.error(msg);
        return new OAuth2AuthenticationException(new OAuth2Error("access_denied"), msg);
    }
}

