/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.oauth.mock.server.token;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;

class BprolesScope {
    private static final Pattern BUSINESS_PARTNER_SCOPE_VALUE_PATTERN = Pattern.compile("bproles:(?<value>\\S+)");
    private static final String ALL_BUSINESS_PARTNERS_VALUE = "*";
    private final String value;

    static BprolesScope from(String scope) {
        String value = BprolesScope.extractBprolesScopeValue(scope);
        return value != null ? new BprolesScope(value) : null;
    }

    boolean includesAllPartners() {
        return ALL_BUSINESS_PARTNERS_VALUE.equals(this.value);
    }

    String getBusinessPartner() {
        if (!this.includesAllPartners()) {
            return this.value;
        }
        return null;
    }

    private static String extractBprolesScopeValue(String scope) {
        if (scope == null) {
            return null;
        }
        Matcher businessPartnerMatcher = BUSINESS_PARTNER_SCOPE_VALUE_PATTERN.matcher(scope);
        if (businessPartnerMatcher.matches()) {
            return businessPartnerMatcher.group("value");
        }
        return null;
    }

    @Generated
    private BprolesScope(String value) {
        this.value = value;
    }
}

