/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.oauth.mock.server.security;

import ch.admin.bit.jeap.oauth.mock.server.config.ClientData;
import ch.admin.bit.jeap.oauth.mock.server.config.OAuthMockData;
import ch.admin.bit.jeap.oauth.mock.server.login.CustomLoginDetails;
import ch.admin.bit.jeap.oauth.mock.server.token.Claims;
import ch.admin.bit.jeap.oauth.mock.server.token.PamsJwtAccessTokenCustomizer;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Token;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.server.authorization.OAuth2Authorization;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationService;
import org.springframework.security.oauth2.server.authorization.OAuth2TokenIntrospection;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2TokenIntrospectionAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;

public class CustomTokenIntrospectionAuthenticationProvider
implements AuthenticationProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CustomTokenIntrospectionAuthenticationProvider.class);
    private final OAuth2AuthorizationService authorizationService;
    private final JwtDecoder jwtDecoder;
    private final OAuthMockData oAuthMockData;

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        OAuth2TokenIntrospectionAuthenticationToken introspectionAuth = (OAuth2TokenIntrospectionAuthenticationToken)authentication;
        String tokenValue = introspectionAuth.getToken();
        OAuth2Authorization authorization = this.authorizationService.findByToken(tokenValue, null);
        if (authorization == null) {
            throw new OAuth2AuthenticationException("invalid_token");
        }
        OAuth2Token token = authorization.getAccessToken().getToken();
        if (token == null) {
            throw new OAuth2AuthenticationException("invalid_token");
        }
        Instant expiresAt = token.getExpiresAt();
        if (expiresAt == null || expiresAt.isBefore(Instant.now())) {
            throw new OAuth2AuthenticationException("invalid_token");
        }
        LinkedHashMap<String, Object> claims = new LinkedHashMap<String, Object>(this.jwtDecoder.decode(tokenValue).getClaims());
        claims.put("active", true);
        if (claims.containsKey(Claims.ROLES_PRUNED_CHARS_CLAIM_NAME.claim())) {
            claims.remove(Claims.ROLES_PRUNED_CHARS_CLAIM_NAME.claim());
            UsernamePasswordAuthenticationToken principal = (UsernamePasswordAuthenticationToken)authorization.getAttribute("java.security.Principal");
            if (principal != null && principal.getDetails() != null) {
                CustomLoginDetails details = (CustomLoginDetails)((Object)principal.getDetails());
                claims.put(Claims.USERROLES.claim(), details.getUserRoles());
                claims.put(Claims.BPROLES.claim(), CustomTokenIntrospectionAuthenticationProvider.getBpRolesMap(details.getBpRoles()));
            } else {
                RegisteredClient client = this.oAuthMockData.clientsById().get(authorization.getPrincipalName());
                if (ClientData.getUserRolesForClient(client) != null) {
                    claims.put(Claims.USERROLES.claim(), ClientData.getUserRolesForClient(client));
                }
                if (ClientData.getBusinessPartnerRolesForClient(client) != null) {
                    claims.put(Claims.BPROLES.claim(), ClientData.getBusinessPartnerRolesForClient(client));
                    PamsJwtAccessTokenCustomizer.applyBprolesScope(client, claims);
                }
            }
        }
        log.debug("Added userRoles to token response: {}", claims.get(Claims.USERROLES.claim()));
        log.debug("Added bpRoles to token response: {}", claims.get(Claims.BPROLES.claim()));
        return new OAuth2TokenIntrospectionAuthenticationToken(tokenValue, (Authentication)introspectionAuth, OAuth2TokenIntrospection.builder().claims(cl -> cl.putAll(claims)).build());
    }

    private static Map<String, List<String>> getBpRolesMap(List<String> bpRoles) {
        bpRoles.remove("");
        LinkedHashMap<String, List<String>> bpRolesMap = new LinkedHashMap<String, List<String>>();
        for (String bpRole : bpRoles) {
            String[] parts;
            if (bpRole.isEmpty() || (parts = bpRole.split(":", 2)).length != 2) continue;
            bpRolesMap.computeIfAbsent(parts[0], k -> new ArrayList()).add(parts[1]);
            Collections.sort((List)bpRolesMap.get(parts[0]));
        }
        return bpRolesMap;
    }

    public boolean supports(Class<?> authentication) {
        return OAuth2TokenIntrospectionAuthenticationToken.class.isAssignableFrom(authentication);
    }

    @Generated
    public CustomTokenIntrospectionAuthenticationProvider(OAuth2AuthorizationService authorizationService, JwtDecoder jwtDecoder, OAuthMockData oAuthMockData) {
        this.authorizationService = authorizationService;
        this.jwtDecoder = jwtDecoder;
        this.oAuthMockData = oAuthMockData;
    }
}

