/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.oauth.mock.server.token;

import ch.admin.bit.jeap.oauth.mock.server.config.OAuthMockData;
import ch.admin.bit.jeap.oauth.mock.server.token.Claims;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JeapRolesPruningTokenMapper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JeapRolesPruningTokenMapper.class);
    private final int rolesPruningLimit;

    public JeapRolesPruningTokenMapper(OAuthMockData oAuthMockData) {
        this.rolesPruningLimit = oAuthMockData.getRolesPruningLimit();
        log.info("Configured rolesPruningLimit: {}", (Object)this.rolesPruningLimit);
    }

    public void pruneRolesInClaimsIfNecessary(Map<String, Object> claims) {
        int userRolesSize;
        int bpRolesSize;
        int rolesSize;
        HashMap<String, List<String>> bpRoles = new HashMap();
        if (claims.get("bproles") instanceof Map) {
            bpRoles = (Map)claims.get("bproles");
        }
        ArrayList<String> userRoles = new ArrayList();
        if (claims.get("userroles") instanceof List) {
            userRoles = (List)claims.get("userroles");
        }
        if ((rolesSize = (bpRolesSize = this.calculateBpRolesSize(bpRoles)) + (userRolesSize = this.calculateUserRolesSize(userRoles))) > this.rolesPruningLimit) {
            log.debug("The combined size of userRoles and bpRoles {} is greater than rolesPruningLimit {}: pruning roles in token", (Object)rolesSize, (Object)this.rolesPruningLimit);
            claims.remove(Claims.USERROLES.claim());
            claims.remove(Claims.BPROLES.claim());
            claims.put(Claims.ROLES_PRUNED_CHARS_CLAIM_NAME.claim(), rolesSize);
        }
    }

    private int calculateBpRolesSize(Map<String, List<String>> bpRoles) {
        if (bpRoles.isEmpty()) {
            return 0;
        }
        int size = 12;
        for (Map.Entry<String, List<String>> entry : bpRoles.entrySet()) {
            size += entry.getKey().length() + 5;
            size += this.calculateRoleListSize(entry.getValue());
        }
        if (bpRoles.size() > 1) {
            size += bpRoles.size() - 1;
        }
        return size;
    }

    private int calculateUserRolesSize(List<String> userRoles) {
        if (userRoles.isEmpty()) {
            return 0;
        }
        int size = 14;
        return size += this.calculateRoleListSize(userRoles);
    }

    private int calculateRoleListSize(List<String> roles) {
        int size = 0;
        for (String role : roles) {
            if (role == null) continue;
            size += role.length() + 2;
        }
        if (roles.size() > 1) {
            size += roles.size() - 1;
        }
        return size;
    }
}

