/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.oauth.mock.server.login;

import ch.admin.bit.jeap.oauth.mock.server.config.ClientData;
import ch.admin.bit.jeap.oauth.mock.server.config.OAuthMockData;
import ch.admin.bit.jeap.oauth.mock.server.login.CustomLoginDetails;
import jakarta.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.security.web.savedrequest.HttpSessionRequestCache;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.security.web.savedrequest.SavedRequest;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class CustomLoginController {
    public static final String LOGIN_FORM_PATH = "/openIdMockServerLogin";
    private final RequestCache requestCache = new HttpSessionRequestCache();
    private final Map<String, RegisteredClient> clientsById;
    private final List<OAuthMockData.UserData> users;

    public CustomLoginController(Map<String, RegisteredClient> clientsById, List<OAuthMockData.UserData> users) {
        this.clientsById = clientsById;
        this.users = users;
    }

    @GetMapping(value={"/openIdMockServerLogin"})
    public ModelAndView login(Model model, HttpServletRequest request) {
        if (request.getParameterMap().containsKey("logout")) {
            return new ModelAndView("logout", model.asMap());
        }
        RegisteredClient client = this.requireClientFromOAuthRequest(request);
        OAuthMockData.UserData defaultUser = this.getUser(request.getParameter("user"));
        model.addAttribute("defaultUsername", (Object)defaultUser.getId());
        model.addAttribute("users", this.users);
        model.addAttribute("roles", this.mergeClientWithUserRoles(client));
        Map<String, Set<String>> bpRoles = this.transposeAvailableRoles(client);
        model.addAttribute("bpRoles", CustomLoginDetails.bpRolesAsFlatList(bpRoles));
        model.addAttribute("preSelectedUserRoles", defaultUser.getUserroles());
        model.addAttribute("preSelectedBpRoles", CustomLoginDetails.bpRolesAsFlatList(defaultUser.getBproles()));
        return new ModelAndView("login", model.asMap());
    }

    private OAuthMockData.UserData getUser(String userId) {
        return this.users.stream().filter(user -> user.getId().equals(userId != null && !userId.isEmpty() ? userId : null)).findFirst().orElse(this.users.get(0));
    }

    List<String> mergeClientWithUserRoles(RegisteredClient client) {
        List<String> userRolesForClient = ClientData.getUserRolesForClient(client);
        List<Object> clientRoles = userRolesForClient == null ? List.of() : userRolesForClient;
        return Stream.concat(clientRoles.stream(), this.users.stream().flatMap(user -> user.getUserroles().stream())).distinct().sorted().collect(Collectors.toList());
    }

    Map<String, Set<String>> transposeAvailableRoles(RegisteredClient client) {
        HashMap<String, Set<String>> bproles = new HashMap<String, Set<String>>();
        Map<String, List<String>> businessPartnerRolesForClient = ClientData.getBusinessPartnerRolesForClient(client);
        if (businessPartnerRolesForClient != null) {
            businessPartnerRolesForClient.forEach((key, values) -> bproles.put((String)key, new TreeSet(values)));
        }
        this.users.forEach(user -> user.getBproles().keySet().forEach(bpid -> {
            List<String> bpRolesForUser = user.getBproles().get(bpid);
            bproles.computeIfAbsent((String)bpid, id -> new TreeSet()).addAll(bpRolesForUser);
        }));
        return bproles;
    }

    private RegisteredClient requireClientFromOAuthRequest(HttpServletRequest request) {
        RegisteredClient clientData = this.getClientFromSavedRequest(request);
        if (clientData == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Unknown or missing client ID");
        }
        return clientData;
    }

    RegisteredClient getClientFromSavedRequest(HttpServletRequest request) {
        SavedRequest oauthRequest = this.requestCache.getRequest(request, null);
        String[] clientIds = oauthRequest == null ? null : oauthRequest.getParameterValues("client_id");
        return this.getClientById(clientIds);
    }

    RegisteredClient getClientById(String[] clientIds) {
        if (clientIds != null && clientIds.length == 1) {
            String clientId = clientIds[0];
            return this.clientsById.get(clientId);
        }
        return null;
    }
}

