/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.oauth.mock.server.login;

import ch.admin.bit.jeap.oauth.mock.server.config.OAuthMockData;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.security.web.authentication.WebAuthenticationDetails;
import org.springframework.util.StringUtils;

public class CustomLoginDetails
extends WebAuthenticationDetails {
    private static final String BP_ROLE_SEPARATOR = ":";
    private static final String LIST_TEXTFIELD_SEPARATOR = "[\\s,]+";
    private final String givenName;
    private final String familyName;
    private final String email;
    private final String locale;
    private final String preferredUserName;
    private final String extId;
    private final String adminDirUID;
    private final String loginLevel;
    private final List<String> userRoles;
    private final List<String> bpRoles;

    public static CustomLoginDetails fromRequest(HttpServletRequest request) {
        String givenName = request.getParameter("givenname");
        String familyName = request.getParameter("familyname");
        String email = request.getParameter("email");
        String locale = request.getParameter("locale");
        String preferredUsername = request.getParameter("preferredusername");
        String extId = request.getParameter("extid");
        String adminDirUID = request.getParameter("admindiruid");
        String loginLevel = request.getParameter("loginlevel");
        String[] userroles = request.getParameterValues("userroles");
        String additionaluserroles = request.getParameter("additionaluserroles");
        String[] bproles = request.getParameterValues("bproles");
        String additionalbproles = request.getParameter("additionalbproles");
        return new CustomLoginDetails(request, givenName, familyName, email, locale, preferredUsername, extId, adminDirUID, loginLevel, userroles, additionaluserroles, bproles, additionalbproles);
    }

    CustomLoginDetails(HttpServletRequest request, String givenName, String familyName, String email, String locale, String preferredUserName, String extId, String adminDirUID, String loginLevel, String[] userRoles, String additionalUserRoles, String[] bpRoles, String additionalBpRoles) {
        super(request);
        this.givenName = givenName;
        this.familyName = familyName;
        this.email = email;
        this.locale = locale;
        this.preferredUserName = preferredUserName;
        this.extId = extId;
        this.adminDirUID = adminDirUID;
        this.loginLevel = loginLevel;
        List<String> list = this.userRoles = userRoles == null ? new ArrayList<String>() : new ArrayList<String>(Arrays.asList(userRoles));
        if (StringUtils.hasText((String)additionalUserRoles)) {
            this.userRoles.addAll(Arrays.asList(additionalUserRoles.split(LIST_TEXTFIELD_SEPARATOR)));
        }
        this.bpRoles = bpRoles == null ? new ArrayList<String>() : new ArrayList<String>(Arrays.asList(bpRoles));
        this.bpRoles.addAll(Arrays.asList(additionalBpRoles.split(LIST_TEXTFIELD_SEPARATOR)));
    }

    public OAuthMockData.UserData toUserDataWithDefaults(OAuthMockData.UserData userDataDefaults) {
        OAuthMockData.UserData.UserDataBuilder userDataBuilder = userDataDefaults.toBuilder();
        if (StringUtils.hasText((String)this.familyName)) {
            userDataBuilder.familyName(this.familyName);
        }
        if (StringUtils.hasText((String)this.givenName)) {
            userDataBuilder.givenName(this.givenName);
        }
        if (StringUtils.hasText((String)this.email)) {
            userDataBuilder.email(this.email);
        }
        if (StringUtils.hasText((String)this.locale)) {
            userDataBuilder.locale(this.locale);
        }
        if (StringUtils.hasText((String)this.preferredUserName)) {
            userDataBuilder.preferredUsername(this.preferredUserName);
        }
        if (StringUtils.hasText((String)this.extId)) {
            userDataBuilder.extId(this.extId);
        }
        if (StringUtils.hasText((String)this.adminDirUID)) {
            userDataBuilder.adminDirUID(this.adminDirUID);
        }
        if (StringUtils.hasText((String)this.loginLevel)) {
            userDataBuilder.loginLevel(this.loginLevel);
        }
        userDataBuilder.userroles(this.userRoles);
        userDataBuilder.bproles(CustomLoginDetails.bpRolesFromFlatList(this.bpRoles));
        return userDataBuilder.build();
    }

    static List<String> bpRolesAsFlatList(Map<String, ? extends Collection<String>> bpRoles) {
        if (bpRoles == null) {
            return Collections.emptyList();
        }
        return bpRoles.entrySet().stream().flatMap(entry -> ((Collection)entry.getValue()).stream().map(bpRole -> (String)entry.getKey() + BP_ROLE_SEPARATOR + bpRole)).distinct().sorted().collect(Collectors.toList());
    }

    private static Map<String, List<String>> bpRolesFromFlatList(List<String> bpRoles) {
        return bpRoles.stream().map(role -> role.split(BP_ROLE_SEPARATOR)).filter(rolePerPartner -> ((String[])rolePerPartner).length == 2).collect(Collectors.groupingBy(CustomLoginDetails::extractBusinessPartner, Collectors.mapping(CustomLoginDetails::extractBusinessPartnerRole, Collectors.toList())));
    }

    private static String extractBusinessPartner(String[] role) {
        return role[0];
    }

    private static String extractBusinessPartnerRole(String[] role) {
        return role[1];
    }

    @Generated
    public String getGivenName() {
        return this.givenName;
    }

    @Generated
    public String getFamilyName() {
        return this.familyName;
    }

    @Generated
    public String getEmail() {
        return this.email;
    }

    @Generated
    public String getLocale() {
        return this.locale;
    }

    @Generated
    public String getPreferredUserName() {
        return this.preferredUserName;
    }

    @Generated
    public String getExtId() {
        return this.extId;
    }

    @Generated
    public String getAdminDirUID() {
        return this.adminDirUID;
    }

    @Generated
    public String getLoginLevel() {
        return this.loginLevel;
    }

    @Generated
    public List<String> getUserRoles() {
        return this.userRoles;
    }

    @Generated
    public List<String> getBpRoles() {
        return this.bpRoles;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CustomLoginDetails)) {
            return false;
        }
        CustomLoginDetails other = (CustomLoginDetails)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$givenName = this.getGivenName();
        String other$givenName = other.getGivenName();
        if (this$givenName == null ? other$givenName != null : !this$givenName.equals(other$givenName)) {
            return false;
        }
        String this$familyName = this.getFamilyName();
        String other$familyName = other.getFamilyName();
        if (this$familyName == null ? other$familyName != null : !this$familyName.equals(other$familyName)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        String this$locale = this.getLocale();
        String other$locale = other.getLocale();
        if (this$locale == null ? other$locale != null : !this$locale.equals(other$locale)) {
            return false;
        }
        String this$preferredUserName = this.getPreferredUserName();
        String other$preferredUserName = other.getPreferredUserName();
        if (this$preferredUserName == null ? other$preferredUserName != null : !this$preferredUserName.equals(other$preferredUserName)) {
            return false;
        }
        String this$extId = this.getExtId();
        String other$extId = other.getExtId();
        if (this$extId == null ? other$extId != null : !this$extId.equals(other$extId)) {
            return false;
        }
        String this$adminDirUID = this.getAdminDirUID();
        String other$adminDirUID = other.getAdminDirUID();
        if (this$adminDirUID == null ? other$adminDirUID != null : !this$adminDirUID.equals(other$adminDirUID)) {
            return false;
        }
        String this$loginLevel = this.getLoginLevel();
        String other$loginLevel = other.getLoginLevel();
        if (this$loginLevel == null ? other$loginLevel != null : !this$loginLevel.equals(other$loginLevel)) {
            return false;
        }
        List<String> this$userRoles = this.getUserRoles();
        List<String> other$userRoles = other.getUserRoles();
        if (this$userRoles == null ? other$userRoles != null : !((Object)this$userRoles).equals(other$userRoles)) {
            return false;
        }
        List<String> this$bpRoles = this.getBpRoles();
        List<String> other$bpRoles = other.getBpRoles();
        return !(this$bpRoles == null ? other$bpRoles != null : !((Object)this$bpRoles).equals(other$bpRoles));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CustomLoginDetails;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $givenName = this.getGivenName();
        result = result * 59 + ($givenName == null ? 43 : $givenName.hashCode());
        String $familyName = this.getFamilyName();
        result = result * 59 + ($familyName == null ? 43 : $familyName.hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        String $locale = this.getLocale();
        result = result * 59 + ($locale == null ? 43 : $locale.hashCode());
        String $preferredUserName = this.getPreferredUserName();
        result = result * 59 + ($preferredUserName == null ? 43 : $preferredUserName.hashCode());
        String $extId = this.getExtId();
        result = result * 59 + ($extId == null ? 43 : $extId.hashCode());
        String $adminDirUID = this.getAdminDirUID();
        result = result * 59 + ($adminDirUID == null ? 43 : $adminDirUID.hashCode());
        String $loginLevel = this.getLoginLevel();
        result = result * 59 + ($loginLevel == null ? 43 : $loginLevel.hashCode());
        List<String> $userRoles = this.getUserRoles();
        result = result * 59 + ($userRoles == null ? 43 : ((Object)$userRoles).hashCode());
        List<String> $bpRoles = this.getBpRoles();
        result = result * 59 + ($bpRoles == null ? 43 : ((Object)$bpRoles).hashCode());
        return result;
    }
}

