/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.oauth.mock.server.config;

import java.util.Set;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;

public enum AuthContext {
    SYS(AuthorizationGrantType.CLIENT_CREDENTIALS, ClientAuthenticationMethod.CLIENT_SECRET_BASIC, ClientAuthenticationMethod.CLIENT_SECRET_POST),
    B2B(AuthorizationGrantType.CLIENT_CREDENTIALS, ClientAuthenticationMethod.CLIENT_SECRET_BASIC, ClientAuthenticationMethod.CLIENT_SECRET_POST),
    USER(AuthorizationGrantType.AUTHORIZATION_CODE, ClientAuthenticationMethod.NONE, ClientAuthenticationMethod.CLIENT_SECRET_POST);

    private final AuthorizationGrantType grantType;
    private final Set<ClientAuthenticationMethod> clientAuthenticationMethods;

    private AuthContext(AuthorizationGrantType grantType, ClientAuthenticationMethod ... clientAuthenticationMethods) {
        this.grantType = grantType;
        this.clientAuthenticationMethods = Set.of(clientAuthenticationMethods);
    }

    public AuthorizationGrantType grantType() {
        return this.grantType;
    }

    public Set<ClientAuthenticationMethod> clientAuthenticationMethods() {
        return this.clientAuthenticationMethods;
    }
}

