/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.oauth.mock.server.security;

import ch.admin.bit.jeap.oauth.mock.server.config.ClientData;
import ch.admin.bit.jeap.oauth.mock.server.config.MockServerConfig;
import ch.admin.bit.jeap.oauth.mock.server.config.OAuthMockData;
import ch.admin.bit.jeap.oauth.mock.server.login.CustomLoginDetails;
import ch.admin.bit.jeap.oauth.mock.server.login.ForceLoginFormFilter;
import ch.admin.bit.jeap.oauth.mock.server.security.CustomTokenIntrospectionAuthenticationProvider;
import ch.admin.bit.jeap.oauth.mock.server.security.InMemoryRegisteredClientRepository;
import ch.admin.bit.jeap.oauth.mock.server.token.JeapRolesPruningTokenMapper;
import ch.admin.bit.jeap.oauth.mock.server.token.PamsJwtTokenCustomizer;
import ch.admin.bit.jeap.oauth.mock.server.token.UserInfoMapper;
import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jose.jwk.source.ImmutableJWKSet;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jose.util.Base64;
import com.nimbusds.jose.util.Base64URL;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.Order;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.factory.PasswordEncoderFactories;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.server.authorization.InMemoryOAuth2AuthorizationService;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationService;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AuthorizationCodeRequestAuthenticationContext;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AuthorizationCodeRequestAuthenticationException;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AuthorizationCodeRequestAuthenticationProvider;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AuthorizationCodeRequestAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClientRepository;
import org.springframework.security.oauth2.server.authorization.config.annotation.web.configuration.OAuth2AuthorizationServerConfiguration;
import org.springframework.security.oauth2.server.authorization.config.annotation.web.configurers.OAuth2AuthorizationServerConfigurer;
import org.springframework.security.oauth2.server.authorization.settings.AuthorizationServerSettings;
import org.springframework.security.oauth2.server.authorization.token.JwtEncodingContext;
import org.springframework.security.oauth2.server.authorization.token.OAuth2TokenCustomizer;
import org.springframework.security.provisioning.InMemoryUserDetailsManager;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;
import org.springframework.security.web.authentication.logout.LogoutFilter;
import org.springframework.util.StringUtils;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;

@Configuration
public class SecurityConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SecurityConfig.class);
    private static final String SECRET = "secret";
    private static final String ANY = "*";

    @Bean
    public OAuth2AuthorizationService authorizationService() {
        return new InMemoryOAuth2AuthorizationService();
    }

    @Bean
    @Order(value=1)
    public SecurityFilterChain authorizationServerSecurityFilterChain(HttpSecurity http, JwtDecoder jwtDecoder, OAuthMockData oAuthMockData) throws Exception {
        OAuth2AuthorizationServerConfigurer authorizationServerConfigurer = OAuth2AuthorizationServerConfigurer.authorizationServer();
        ((HttpSecurity)http.securityMatcher(authorizationServerConfigurer.getEndpointsMatcher()).with((SecurityConfigurerAdapter)authorizationServerConfigurer, Customizer.withDefaults())).authorizeHttpRequests(authorize -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorize.anyRequest()).authenticated());
        http.cors(cors -> cors.configurationSource(this.corsConfigurationSource()));
        http.addFilterBefore((Filter)new ForceLoginFormFilter(), LogoutFilter.class);
        ((OAuth2AuthorizationServerConfigurer)http.getConfigurer(OAuth2AuthorizationServerConfigurer.class)).authorizationEndpoint(authorizationEndpoint -> authorizationEndpoint.authenticationProviders(this.configureAuthenticationValidator())).tokenIntrospectionEndpoint(tokenIntrospectionEndpoint -> tokenIntrospectionEndpoint.authenticationProvider((AuthenticationProvider)new CustomTokenIntrospectionAuthenticationProvider(this.authorizationService(), jwtDecoder, oAuthMockData))).oidc(oidc -> oidc.userInfoEndpoint(userInfoEndpoint -> userInfoEndpoint.userInfoMapper((Function)new UserInfoMapper())));
        http.exceptionHandling(exceptions -> exceptions.authenticationEntryPoint((AuthenticationEntryPoint)new LoginUrlAuthenticationEntryPoint("/openIdMockServerLogin"))).oauth2ResourceServer(c -> c.jwt(Customizer.withDefaults()));
        return (SecurityFilterChain)http.build();
    }

    @Bean
    @Order(value=2)
    public SecurityFilterChain defaultSecurityFilterChain(HttpSecurity http) throws Exception {
        http.cors(cors -> cors.configurationSource(this.corsConfigurationSource()));
        http.csrf(c -> c.disable());
        http.headers(h -> h.frameOptions(f -> f.disable()).contentSecurityPolicy(p -> p.policyDirectives("frame-ancestors 'self' http://*:* https://*:*")));
        http.authorizeHttpRequests(authorize -> {
            ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorize.requestMatchers(new String[]{"/openIdMockServerLogin"})).permitAll();
            ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorize.requestMatchers(new String[]{"/styles/**"})).permitAll();
            ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorize.requestMatchers(new String[]{"/favicon.ico"})).permitAll();
            ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorize.requestMatchers(new String[]{"/.well-known/**"})).permitAll();
            ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorize.requestMatchers(new String[]{"/protocol/**"})).permitAll();
            ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorize.dispatcherTypeMatchers(new DispatcherType[]{DispatcherType.ERROR})).permitAll();
            ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorize.anyRequest()).authenticated();
        }).formLogin(c -> ((FormLoginConfigurer)c.authenticationDetailsSource(CustomLoginDetails::fromRequest)).loginPage("/openIdMockServerLogin"));
        return (SecurityFilterChain)http.build();
    }

    @Bean
    public CorsConfigurationSource corsConfigurationSource() {
        CorsConfiguration configuration = new CorsConfiguration();
        configuration.addAllowedOrigin(ANY);
        configuration.addAllowedHeader(ANY);
        configuration.addAllowedMethod(ANY);
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        source.registerCorsConfiguration("/userinfo", configuration);
        source.registerCorsConfiguration("/.well-known/**", configuration);
        source.registerCorsConfiguration("/protocol/**", configuration);
        source.registerCorsConfiguration("/oauth2/**", configuration);
        return source;
    }

    @Bean
    public RegisteredClientRepository registeredClientRepository(OAuthMockData oAuthMockData) {
        return new InMemoryRegisteredClientRepository(oAuthMockData.getClients().stream().map(ClientData::toRegisteredClient).collect(Collectors.toList()));
    }

    @Bean
    public UserDetailsService userDetailsService(OAuthMockData oAuthMockData) {
        List userDetails = oAuthMockData.getUsers().stream().map(this::createUserDetails).collect(Collectors.toList());
        return new InMemoryUserDetailsManager(userDetails);
    }

    private UserDetails createUserDetails(OAuthMockData.UserData userData) {
        PasswordEncoder encoder = PasswordEncoderFactories.createDelegatingPasswordEncoder();
        return User.builder().passwordEncoder(arg_0 -> ((PasswordEncoder)encoder).encode(arg_0)).username(userData.getId()).password(SECRET).authorities(List.of()).build();
    }

    @Bean
    public JWKSource<SecurityContext> jwkSource(KeyPair keyPair) throws CertificateException, OperatorCreationException, NoSuchAlgorithmException {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
        RSAPrivateKey privateKey = (RSAPrivateKey)keyPair.getPrivate();
        RSAKey rsaKey = SecurityConfig.getRsaKey(keyPair, privateKey, publicKey);
        return new ImmutableJWKSet(new JWKSet((JWK)rsaKey));
    }

    private static RSAKey getRsaKey(KeyPair keyPair, RSAPrivateKey privateKey, RSAPublicKey publicKey) throws OperatorCreationException, CertificateException, NoSuchAlgorithmException {
        X509Certificate certificate = SecurityConfig.getX509Certificate(keyPair, privateKey);
        byte[] derEncoded = certificate.getEncoded();
        String base64Encoded = java.util.Base64.getEncoder().encodeToString(derEncoded);
        MessageDigest sha1 = MessageDigest.getInstance("SHA-1");
        byte[] sha1Digest = sha1.digest(derEncoded);
        MessageDigest sha256 = MessageDigest.getInstance("SHA-256");
        byte[] sha256Digest = sha256.digest(derEncoded);
        return new RSAKey.Builder(publicKey).privateKey(privateKey).keyID(UUID.randomUUID().toString()).x509CertChain(List.of(Base64.encode((byte[])derEncoded))).x509CertThumbprint(Base64URL.encode((byte[])sha1Digest)).x509CertSHA256Thumbprint(Base64URL.encode((byte[])sha256Digest)).algorithm(Algorithm.parse((String)"RS256")).build();
    }

    private static X509Certificate getX509Certificate(KeyPair keyPair, RSAPrivateKey privateKey) throws OperatorCreationException, CertificateException {
        X500Name issuer = new X500Name("CN=Mock Server CA, O=jEAP, L=Bern, ST=Bern, C=Switzerland");
        X500Name subject = new X500Name("CN=Mock Subject, O=jEAP, L=Bern, ST=Bern, C=Switzerland");
        BigInteger serialNumber = new BigInteger(64, new SecureRandom());
        Date notBefore = new Date(System.currentTimeMillis() - TimeUnit.DAYS.toMillis(24L));
        Date notAfter = new Date(System.currentTimeMillis() + TimeUnit.DAYS.toMillis(365L));
        JcaX509v3CertificateBuilder certificateBuilder = new JcaX509v3CertificateBuilder(issuer, serialNumber, notBefore, notAfter, subject, keyPair.getPublic());
        ContentSigner contentSigner = new JcaContentSignerBuilder("SHA256WithRSAEncryption").build((PrivateKey)privateKey);
        X509CertificateHolder certificateHolder = certificateBuilder.build(contentSigner);
        return new JcaX509CertificateConverter().setProvider("BC").getCertificate(certificateHolder);
    }

    @Bean
    KeyPair keyPair(MockServerConfig mockServerConfig) {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
            keyPairGenerator.initialize(2048, new SecureRandom());
            return keyPairGenerator.generateKeyPair();
        }
        catch (GeneralSecurityException gse) {
            throw new IllegalStateException("Unable to create RSA key pair. Maybe there is a problem with the cryptography provider?", gse);
        }
    }

    @Bean
    public BeanFactoryPostProcessor beanFactoryPostProcessor() {
        return factory -> {
            BeanDefinitionRegistry registry = (BeanDefinitionRegistry)factory;
            if (!SecurityConfig.isBeanCustomizerRegistered(factory)) {
                registry.registerBeanDefinition("tokenCustomizer", (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(PamsJwtTokenCustomizer.class).getBeanDefinition());
            }
        };
    }

    private static boolean isBeanCustomizerRegistered(ConfigurableListableBeanFactory factory) {
        String[] existingBeanCustomizerBeans = factory.getBeanNamesForType(ResolvableType.forClassWithGenerics(OAuth2TokenCustomizer.class, (Class[])new Class[]{JwtEncodingContext.class}));
        return existingBeanCustomizerBeans.length > 0;
    }

    @Bean
    public JwtDecoder jwtDecoder(JWKSource<SecurityContext> jwkSource) {
        return OAuth2AuthorizationServerConfiguration.jwtDecoder(jwkSource);
    }

    @Bean
    public JeapRolesPruningTokenMapper jeapRolesPruningTokenMapper(OAuthMockData oAuthMockData) {
        return new JeapRolesPruningTokenMapper(oAuthMockData);
    }

    @Bean
    public AuthorizationServerSettings authorizationServerSettings(MockServerConfig mockServerConfig) {
        return AuthorizationServerSettings.builder().issuer(mockServerConfig.getBaseUrl()).jwkSetEndpoint("/.well-known/jwks.json").build();
    }

    private Consumer<List<AuthenticationProvider>> configureAuthenticationValidator() {
        return authenticationProviders -> authenticationProviders.forEach(authenticationProvider -> {
            if (authenticationProvider instanceof OAuth2AuthorizationCodeRequestAuthenticationProvider) {
                OAuth2AuthorizationCodeRequestAuthenticationProvider oauthProvider = (OAuth2AuthorizationCodeRequestAuthenticationProvider)authenticationProvider;
                Consumer<OAuth2AuthorizationCodeRequestAuthenticationContext> authenticationValidator = new CustomRedirectUriValidator().andThen(SecurityConfig::validateScopeSupportingDynamicScopes);
                oauthProvider.setAuthenticationValidator(authenticationValidator);
            }
        });
    }

    private static void validateScopeSupportingDynamicScopes(OAuth2AuthorizationCodeRequestAuthenticationContext authenticationContext) {
        Set allowedScopes;
        OAuth2AuthorizationCodeRequestAuthenticationToken authorizationCodeRequestAuthentication = (OAuth2AuthorizationCodeRequestAuthenticationToken)authenticationContext.getAuthentication();
        RegisteredClient registeredClient = authenticationContext.getRegisteredClient();
        Set requestedScopes = authorizationCodeRequestAuthentication.getScopes();
        if (!SecurityConfig.requestedScopesMatchingAllowedScopes(requestedScopes, allowedScopes = registeredClient.getScopes())) {
            OAuth2Error error = new OAuth2Error("invalid_scope", "OAuth 2.0 Parameter: scope", "https://datatracker.ietf.org/doc/html/rfc6749#section-4.1.2.1");
            String redirectUri = StringUtils.hasText((String)authorizationCodeRequestAuthentication.getRedirectUri()) ? authorizationCodeRequestAuthentication.getRedirectUri() : (String)registeredClient.getRedirectUris().iterator().next();
            OAuth2AuthorizationCodeRequestAuthenticationToken authorizationCodeRequestAuthenticationResult = new OAuth2AuthorizationCodeRequestAuthenticationToken(authorizationCodeRequestAuthentication.getAuthorizationUri(), authorizationCodeRequestAuthentication.getClientId(), (Authentication)authorizationCodeRequestAuthentication.getPrincipal(), redirectUri, authorizationCodeRequestAuthentication.getState(), authorizationCodeRequestAuthentication.getScopes(), authorizationCodeRequestAuthentication.getAdditionalParameters());
            authorizationCodeRequestAuthenticationResult.setAuthenticated(true);
            throw new OAuth2AuthorizationCodeRequestAuthenticationException(error, authorizationCodeRequestAuthenticationResult);
        }
    }

    public static boolean requestedScopesMatchingAllowedScopes(Set<String> requestedScopes, Set<String> allowedScopes) {
        Set dynamicScopes = allowedScopes.stream().filter(s -> s.endsWith(":*")).collect(Collectors.toSet());
        Set allowedPlainScopes = allowedScopes.stream().filter(s -> !dynamicScopes.contains(s)).collect(Collectors.toSet());
        Set requestedPlainScopes = requestedScopes.stream().filter(s -> dynamicScopes.stream().noneMatch(d -> s.startsWith(d.substring(0, d.length() - 1)))).collect(Collectors.toSet());
        return requestedPlainScopes.isEmpty() || allowedPlainScopes.containsAll(requestedPlainScopes);
    }

    static class CustomRedirectUriValidator
    implements Consumer<OAuth2AuthorizationCodeRequestAuthenticationContext> {
        CustomRedirectUriValidator() {
        }

        @Override
        public void accept(OAuth2AuthorizationCodeRequestAuthenticationContext authenticationContext) {
            OAuth2AuthorizationCodeRequestAuthenticationToken authorizationCodeRequestAuthentication = (OAuth2AuthorizationCodeRequestAuthenticationToken)authenticationContext.getAuthentication();
            RegisteredClient registeredClient = authenticationContext.getRegisteredClient();
            String requestedRedirectUri = authorizationCodeRequestAuthentication.getRedirectUri();
            if (registeredClient.getRedirectUris().stream().noneMatch(uri -> {
                if (requestedRedirectUri == null) {
                    return false;
                }
                return uri.endsWith(SecurityConfig.ANY) ? requestedRedirectUri.startsWith(uri.substring(0, uri.length() - 1)) : requestedRedirectUri.equals(uri);
            })) {
                this.logAndThrowError(requestedRedirectUri, registeredClient);
            }
        }

        private void logAndThrowError(String requestedRedirectUri, RegisteredClient registeredClient) {
            String msg = String.format("The redirect_uri %s is not valid for the client %s. Expected the redirect uri to match one of: %s}.", requestedRedirectUri, registeredClient.getClientId(), registeredClient.getRedirectUris());
            log.error(msg);
            OAuth2Error error = new OAuth2Error("invalid_request", msg, null);
            throw new OAuth2AuthorizationCodeRequestAuthenticationException(error, null);
        }
    }
}

