/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.oauth.mock.server.token;

import ch.admin.bit.jeap.oauth.mock.server.config.ClientData;
import ch.admin.bit.jeap.oauth.mock.server.config.OAuthMockData;
import ch.admin.bit.jeap.oauth.mock.server.login.CustomLoginDetails;
import ch.admin.bit.jeap.oauth.mock.server.token.AbstractJwtTokenCustomizer;
import ch.admin.bit.jeap.oauth.mock.server.token.BprolesScope;
import ch.admin.bit.jeap.oauth.mock.server.token.Claims;
import ch.admin.bit.jeap.oauth.mock.server.token.JeapRolesPruningTokenMapper;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.security.oauth2.server.authorization.token.JwtEncodingContext;
import org.springframework.util.StringUtils;

public class PamsJwtTokenCustomizer
extends AbstractJwtTokenCustomizer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PamsJwtTokenCustomizer.class);
    private final JeapRolesPruningTokenMapper jeapRolesPruningTokenMapper;

    @Override
    protected void customizeAccessToken(JwtEncodingContext context, Map<String, Object> claims) {
        String clientId = PamsJwtTokenCustomizer.getClientIdFromSecurityContext();
        this.addPamsClaims(context, clientId, claims, context.getPrincipal(), true);
        log.info("Issued access token with claims {}", claims);
    }

    @Override
    protected void customizeIdToken(JwtEncodingContext context, Map<String, Object> claims) {
        String clientId = PamsJwtTokenCustomizer.getClientIdFromSecurityContext();
        this.addPamsClaims(context, clientId, claims, context.getPrincipal(), false);
        this.updatePamsClaimsForIdToken(clientId, claims);
        log.info("Issued id token with claims {}", claims);
    }

    private void addPamsClaims(JwtEncodingContext context, String clientId, Map<String, Object> claims, Authentication userAuthentication, boolean accessToken) {
        RegisteredClient clientData = this.requireClient(clientId);
        PamsJwtTokenCustomizer.addContextClaim(claims, clientData, context.getAuthorizationGrantType());
        this.addAudienceClaim(clientData, claims);
        this.addClientDefaultBpRoleClaim(clientData, claims);
        this.addClientDefaultUserrolesClaim(clientData, claims);
        OAuthMockData.UserData userData = this.getUserDataIfInUserContext(userAuthentication);
        this.addUserClaims(userData, claims);
        this.addBpRoleClaim(userData, claims);
        this.addUserrolesClaim(userData, claims);
        this.addSubjectClaim(clientData, userData, claims);
        this.addAdditionalUserClaims(userData, claims);
        PamsJwtTokenCustomizer.applyBprolesScope(clientData, claims);
        if (accessToken && clientData.getScopes().contains("roles-pruning")) {
            this.jeapRolesPruningTokenMapper.pruneRolesInClaimsIfNecessary(claims);
        }
    }

    public static void applyBprolesScope(RegisteredClient client, Map<String, Object> claims) {
        if (ClientData.isBprolesScopeEnabled(client)) {
            Optional<BprolesScope> bprolesScope = PamsJwtTokenCustomizer.getBprolesScope(claims);
            if (bprolesScope.isEmpty()) {
                PamsJwtTokenCustomizer.removeBprolesClaim(claims);
            } else if (!bprolesScope.get().includesAllPartners()) {
                String businessPartner = bprolesScope.get().getBusinessPartner();
                PamsJwtTokenCustomizer.restrictBprolesClaimToBusinessPartner(claims, businessPartner);
            }
        }
    }

    private static Optional<BprolesScope> getBprolesScope(Map<String, Object> claims) {
        if (claims.getOrDefault("scope", Set.of()) instanceof Set) {
            Set scopes = claims.getOrDefault("scope", Set.of());
            return scopes.stream().map(BprolesScope::from).filter(Objects::nonNull).findFirst();
        }
        if (claims.getOrDefault("scope", List.of()) instanceof List) {
            List scopes = claims.getOrDefault("scope", List.of());
            return scopes.stream().map(BprolesScope::from).filter(Objects::nonNull).findFirst();
        }
        return Optional.empty();
    }

    private static Map<String, List<String>> getBproles(Map<String, Object> claims) {
        return claims.getOrDefault(Claims.BPROLES.claim(), Map.of());
    }

    private static void restrictBprolesClaimToBusinessPartner(Map<String, Object> claims, String businessPartner) {
        List bprolesOfBusinessPartner = PamsJwtTokenCustomizer.getBproles(claims).getOrDefault(businessPartner, List.of());
        if (!bprolesOfBusinessPartner.isEmpty()) {
            claims.put(Claims.BPROLES.claim(), Map.of(businessPartner, bprolesOfBusinessPartner));
        } else {
            PamsJwtTokenCustomizer.removeBprolesClaim(claims);
        }
    }

    private static void removeBprolesClaim(Map<String, Object> claims) {
        claims.remove(Claims.BPROLES.claim());
    }

    private static void addContextClaim(Map<String, Object> claims, RegisteredClient client, AuthorizationGrantType grantType) {
        if (ClientData.getContext(client) != null) {
            claims.put(Claims.CONTEXT.claim(), ClientData.getContext(client));
        } else {
            claims.put(Claims.CONTEXT.claim(), grantType.equals((Object)AuthorizationGrantType.AUTHORIZATION_CODE) ? "USER" : "SYS");
        }
    }

    private void addSubjectClaim(RegisteredClient client, OAuthMockData.UserData userData, Map<String, Object> additionalInfo) {
        String subject = PamsJwtTokenCustomizer.subjectOrUuid(client, userData);
        additionalInfo.put("sub", subject);
    }

    private static String subjectOrUuid(RegisteredClient client, OAuthMockData.UserData userData) {
        if (userData != null && (StringUtils.hasText((String)userData.getSubject()) || StringUtils.hasText((String)userData.getPreferredUsername()))) {
            return StringUtils.hasText((String)userData.getPreferredUsername()) ? userData.getPreferredUsername() : userData.getSubject();
        }
        String subject = ClientData.getSubject(client);
        if (StringUtils.hasText((String)subject)) {
            return subject;
        }
        return UUID.randomUUID().toString();
    }

    private OAuthMockData.UserData getUserDataIfInUserContext(Authentication userAuthentication) {
        Object object;
        if (userAuthentication == null || !((object = userAuthentication.getPrincipal()) instanceof User)) {
            return null;
        }
        User user = (User)object;
        CustomLoginDetails customLoginDetails = (CustomLoginDetails)((Object)userAuthentication.getDetails());
        OAuthMockData.UserData userDataDefaultsFromConfig = this.requireUser(user.getUsername());
        return customLoginDetails.toUserDataWithDefaults(userDataDefaultsFromConfig);
    }

    private void addAudienceClaim(RegisteredClient client, Map<String, Object> additionalInfo) {
        List<String> audience = ClientData.getAudience(client);
        if (audience != null) {
            additionalInfo.put("aud", audience);
        } else {
            additionalInfo.remove("aud");
        }
    }

    private void addClientDefaultUserrolesClaim(RegisteredClient client, Map<String, Object> additionalInfo) {
        List<String> userroles = ClientData.getUserRolesForClient(client);
        if (userroles != null) {
            additionalInfo.put(Claims.USERROLES.claim(), userroles);
        }
    }

    private void addClientDefaultBpRoleClaim(RegisteredClient client, Map<String, Object> additionalInfo) {
        Map<String, List<String>> bproles = ClientData.getBusinessPartnerRolesForClient(client);
        if (bproles != null) {
            additionalInfo.put(Claims.BPROLES.claim(), bproles);
        }
    }

    private void addUserrolesClaim(OAuthMockData.UserData user, Map<String, Object> additionalInfo) {
        if (user != null) {
            List<String> userroles = user.getUserroles();
            additionalInfo.put(Claims.USERROLES.claim(), userroles);
        }
    }

    private void addBpRoleClaim(OAuthMockData.UserData user, Map<String, Object> additionalInfo) {
        if (user != null) {
            Map<String, List<String>> bproles = user.getBproles();
            additionalInfo.put(Claims.BPROLES.claim(), bproles);
        }
    }

    private void addUserClaims(OAuthMockData.UserData user, Map<String, Object> additionalInfo) {
        if (user != null) {
            additionalInfo.put("name", user.getName());
            additionalInfo.put("given_name", user.getGivenName());
            additionalInfo.put("family_name", user.getFamilyName());
            additionalInfo.put("locale", user.getLocale());
            additionalInfo.put("preferred_username", user.getPreferredUsername());
            additionalInfo.put(Claims.EXT_ID.claim(), user.getExtId());
            additionalInfo.put(Claims.ADMIN_DIR_UID.claim(), user.getAdminDirUID());
            additionalInfo.put(Claims.LOGIN.claim(), user.getLoginLevel());
        }
    }

    private void updatePamsClaimsForIdToken(String clientId, Map<String, Object> claims) {
        claims.remove("scope");
        claims.put("aud", clientId);
    }

    @Generated
    public PamsJwtTokenCustomizer(JeapRolesPruningTokenMapper jeapRolesPruningTokenMapper) {
        this.jeapRolesPruningTokenMapper = jeapRolesPruningTokenMapper;
    }
}

