/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.oauth.mock.server.token;

import ch.admin.bit.jeap.oauth.mock.server.token.PamsJwtAccessTokenCustomizer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.oidc.OidcIdToken;
import org.springframework.security.oauth2.core.oidc.OidcUserInfo;
import org.springframework.security.oauth2.server.authorization.OAuth2Authorization;
import org.springframework.security.oauth2.server.authorization.oidc.authentication.OidcUserInfoAuthenticationContext;

public class UserInfoMapper
implements Function<OidcUserInfoAuthenticationContext, OidcUserInfo> {
    private static final List<String> EMAIL_CLAIMS = Arrays.asList("email", "email_verified");
    private static final List<String> PHONE_CLAIMS = Arrays.asList("phone_number", "phone_number_verified");
    private static final List<String> PROFILE_CLAIMS = Arrays.asList("name", "family_name", "given_name", "middle_name", "nickname", "preferred_username", "profile", "picture", "website", "gender", "birthdate", "zoneinfo", "locale", "updated_at");

    @Override
    public OidcUserInfo apply(OidcUserInfoAuthenticationContext authenticationContext) {
        OAuth2Authorization authorization = authenticationContext.getAuthorization();
        OidcIdToken idToken = (OidcIdToken)Objects.requireNonNull(authorization.getToken(OidcIdToken.class)).getToken();
        OAuth2AccessToken accessToken = authenticationContext.getAccessToken();
        Map<String, Object> claims = UserInfoMapper.getClaimsRequestedByScope(idToken.getClaims(), accessToken.getScopes());
        UserInfoMapper.putClaims(claims, PamsJwtAccessTokenCustomizer.Claims.values(), idToken);
        return new OidcUserInfo(claims);
    }

    private static void putClaims(Map<String, Object> claimMap, PamsJwtAccessTokenCustomizer.Claims[] claims, OidcIdToken idToken) {
        Arrays.stream(claims).forEach(claim -> claimMap.put(claim.claim(), idToken.getClaim(claim.claim())));
    }

    private static Map<String, Object> getClaimsRequestedByScope(Map<String, Object> claims, Set<String> requestedScopes) {
        HashSet<String> scopeRequestedClaimNames = new HashSet<String>(32);
        scopeRequestedClaimNames.add("sub");
        if (requestedScopes.contains("address")) {
            scopeRequestedClaimNames.add("address");
        }
        if (requestedScopes.contains("email")) {
            scopeRequestedClaimNames.addAll(EMAIL_CLAIMS);
        }
        if (requestedScopes.contains("phone")) {
            scopeRequestedClaimNames.addAll(PHONE_CLAIMS);
        }
        if (requestedScopes.contains("profile")) {
            scopeRequestedClaimNames.addAll(PROFILE_CLAIMS);
        }
        HashMap<String, Object> requestedClaims = new HashMap<String, Object>(claims);
        requestedClaims.keySet().removeIf(claimName -> !scopeRequestedClaimNames.contains(claimName));
        return requestedClaims;
    }
}

