/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.oauth.mock.server.token;

import ch.admin.bit.jeap.oauth.mock.server.config.ClientData;
import ch.admin.bit.jeap.oauth.mock.server.config.OAuthMockData;
import ch.admin.bit.jeap.oauth.mock.server.login.CustomLoginDetails;
import ch.admin.bit.jeap.oauth.mock.server.token.AbstractJwtTokenCustomizer;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.security.oauth2.server.authorization.token.JwtEncodingContext;
import org.springframework.util.StringUtils;

public class EiamJwtAccessTokenCustomizer
extends AbstractJwtTokenCustomizer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EiamJwtAccessTokenCustomizer.class);

    @Override
    protected void customizeAccessToken(JwtEncodingContext context, Map<String, Object> claims) {
        String clientId = EiamJwtAccessTokenCustomizer.getClientIdFromSecurityContext();
        this.setClaims(clientId, claims, context.getPrincipal());
        log.info("Issued access token with claims " + String.valueOf(claims));
    }

    @Override
    protected void customizeIdToken(JwtEncodingContext context, Map<String, Object> claims) {
        String clientId = EiamJwtAccessTokenCustomizer.getClientIdFromSecurityContext();
        this.setClaims(clientId, claims, context.getPrincipal());
        this.updateClaimsForIdToken(clientId, claims);
        log.info("Issued id token with claims " + String.valueOf(claims));
    }

    private void setClaims(String clientId, Map<String, Object> claims, Authentication userAuthentication) {
        RegisteredClient clientData = this.requireClient(clientId);
        OAuthMockData.UserData userData = this.getUserDataIfInUserContext(userAuthentication);
        this.addSubjectClaim(clientData, userData, claims);
        this.addUserClaims(userData, claims);
        this.addAdditionalUserClaims(userData, claims);
        this.addRoleClaim(userData, clientData, claims);
        this.addAudienceClaim(clientData, claims);
    }

    private void addSubjectClaim(RegisteredClient client, OAuthMockData.UserData userData, Map<String, Object> claims) {
        String subject = EiamJwtAccessTokenCustomizer.subjectOrUuid(client, userData);
        claims.put("sub", subject);
    }

    private void addAudienceClaim(RegisteredClient client, Map<String, Object> additionalInfo) {
        List<String> audience = ClientData.getAudience(client);
        if (audience != null) {
            additionalInfo.put("aud", audience);
        } else {
            additionalInfo.remove("aud");
        }
    }

    private void addRoleClaim(OAuthMockData.UserData user, RegisteredClient client, Map<String, Object> claims) {
        List<String> roles;
        List<String> list = roles = user != null ? user.getUserroles() : ClientData.getUserRolesForClient(client);
        if (roles != null) {
            claims.put(EiamClaims.ROLE.claim(), roles);
        }
    }

    private void addUserClaims(OAuthMockData.UserData user, Map<String, Object> claims) {
        if (user != null) {
            claims.put("name", user.getName());
            claims.put("given_name", user.getGivenName());
            claims.put("family_name", user.getFamilyName());
            claims.put(EiamClaims.LANGUAGE.claim(), user.getLocale().toLowerCase());
            claims.put("preferred_username", user.getPreferredUsername());
            claims.put(EiamClaims.USER_EXT_ID.claim(), user.getExtId());
            claims.put(EiamClaims.EMAIL.claim(), user.getEmail());
        }
    }

    private void updateClaimsForIdToken(String clientId, Map<String, Object> claims) {
        claims.remove("scope");
        claims.put("aud", clientId);
    }

    private static String subjectOrUuid(RegisteredClient client, OAuthMockData.UserData userData) {
        if (userData != null && (StringUtils.hasText((String)userData.getSubject()) || StringUtils.hasText((String)userData.getPreferredUsername()))) {
            return StringUtils.hasText((String)userData.getPreferredUsername()) ? userData.getPreferredUsername() : userData.getSubject();
        }
        String subject = ClientData.getSubject(client);
        if (StringUtils.hasText((String)subject)) {
            return subject;
        }
        return UUID.randomUUID().toString();
    }

    private OAuthMockData.UserData getUserDataIfInUserContext(Authentication userAuthentication) {
        Object object;
        if (userAuthentication == null || !((object = userAuthentication.getPrincipal()) instanceof User)) {
            return null;
        }
        User user = (User)object;
        CustomLoginDetails customLoginDetails = (CustomLoginDetails)((Object)userAuthentication.getDetails());
        OAuthMockData.UserData userDataDefaultsFromConfig = this.requireUser(user.getUsername());
        return customLoginDetails.toUserDataWithDefaults(userDataDefaultsFromConfig);
    }

    private static enum EiamClaims {
        ROLE("role"),
        USER_EXT_ID("userExtId"),
        EMAIL("email"),
        LANGUAGE("language");

        private final String claim;

        private EiamClaims(String claim) {
            this.claim = claim;
        }

        public String claim() {
            return this.claim;
        }
    }
}

