/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.oauth.mock.server.config;

import ch.admin.bit.jeap.oauth.mock.server.config.AuthContext;
import jakarta.validation.constraints.NotEmpty;
import java.time.Duration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.security.oauth2.server.authorization.settings.ClientSettings;
import org.springframework.security.oauth2.server.authorization.settings.TokenSettings;

public class ClientData {
    private static final String USERROLES = "userroles";
    private static final String BPROLES = "bproles";
    private static final String AUDIENCE = "audience";
    private static final String SUBJECT = "subject";
    private static final String CONTEXT = "context";
    private static final String BPROLES_SCOPE_ENABLED = "bproles-scope-enabled";
    private static final String BPROLES_SCOPE = "bproles:*";
    private static final String ROLES_PRUNING_ENABLED = "roles-pruning-enabled";
    private static final String ROLES_PRUNING_SCOPE = "roles-pruning";
    private static final Duration DEFAULT_TOKEN_VALIDITY = Duration.ofHours(1L);
    @NotEmpty
    private String clientId;
    private String clientSecret = null;
    private List<String> registeredRedirectUri = List.of();
    private Long accessTokenValiditySeconds;
    private Long refreshTokenValiditySeconds;
    private AuthContext context = null;
    private String subject = null;
    private List<String> audience = null;
    private List<String> userroles = null;
    private Map<String, List<String>> bproles = null;
    private List<String> scope = List.of();
    private boolean bprolesScopeEnabled = false;
    private boolean rolesPruningEnabled = false;

    public RegisteredClient toRegisteredClient() {
        return RegisteredClient.withId((String)UUID.randomUUID().toString()).clientId(this.clientId).clientSecret(this.clientSecret == null ? null : this.clientSecret).clientAuthenticationMethods(s -> s.addAll(this.getAuthenticationMethods())).authorizationGrantTypes(s -> s.addAll(this.getAuthorizationGrantTypes())).scopes(c -> {
            c.addAll(this.scope);
            c.add("address");
            c.add("phone");
            c.add("profile");
            c.add("openid");
            c.add("email");
            if (this.bprolesScopeEnabled && !this.scope.contains(BPROLES_SCOPE)) {
                c.add(BPROLES_SCOPE);
            }
            if (this.rolesPruningEnabled && !this.scope.contains(ROLES_PRUNING_SCOPE)) {
                c.add(ROLES_PRUNING_SCOPE);
            }
        }).clientSettings(this.createClientSettings()).redirectUris(uris -> uris.addAll(this.registeredRedirectUri)).tokenSettings(TokenSettings.builder().accessTokenTimeToLive(this.accessTokenValiditySeconds != null ? Duration.ofSeconds(this.accessTokenValiditySeconds) : DEFAULT_TOKEN_VALIDITY).refreshTokenTimeToLive(this.refreshTokenValiditySeconds != null ? Duration.ofSeconds(this.refreshTokenValiditySeconds) : DEFAULT_TOKEN_VALIDITY).build()).build();
    }

    private ClientSettings createClientSettings() {
        ClientSettings.Builder builder = ClientSettings.builder().requireAuthorizationConsent(false);
        if (this.context != null) {
            builder.setting(CONTEXT, (Object)this.context.name());
        }
        if (this.userroles != null) {
            builder.setting(USERROLES, this.userroles);
        }
        if (this.bproles != null) {
            builder.setting(BPROLES, this.bproles);
        }
        if (this.audience != null) {
            builder.setting(AUDIENCE, this.audience);
        }
        if (this.subject != null) {
            builder.setting(SUBJECT, (Object)this.subject);
        }
        builder.setting(BPROLES_SCOPE_ENABLED, (Object)this.bprolesScopeEnabled);
        return builder.build();
    }

    private Set<AuthorizationGrantType> getAuthorizationGrantTypes() {
        if (this.context != null) {
            return Set.of(this.context.grantType());
        }
        HashSet<AuthorizationGrantType> authorizationGrantTypes = new HashSet<AuthorizationGrantType>();
        authorizationGrantTypes.add(AuthorizationGrantType.CLIENT_CREDENTIALS);
        if (!this.registeredRedirectUri.isEmpty()) {
            authorizationGrantTypes.add(AuthorizationGrantType.AUTHORIZATION_CODE);
        }
        return authorizationGrantTypes;
    }

    private Set<ClientAuthenticationMethod> getAuthenticationMethods() {
        if (this.context != null) {
            return this.context.clientAuthenticationMethods();
        }
        return Set.of(ClientAuthenticationMethod.CLIENT_SECRET_BASIC, ClientAuthenticationMethod.CLIENT_SECRET_POST, ClientAuthenticationMethod.NONE);
    }

    public static String getContext(RegisteredClient registeredClient) {
        return (String)registeredClient.getClientSettings().getSettings().get(CONTEXT);
    }

    public static String getSubject(RegisteredClient client) {
        return (String)client.getClientSettings().getSettings().get(SUBJECT);
    }

    public static List<String> getAudience(RegisteredClient client) {
        return (List)client.getClientSettings().getSettings().get(AUDIENCE);
    }

    public static List<String> getUserRolesForClient(RegisteredClient client) {
        return (List)client.getClientSettings().getSettings().get(USERROLES);
    }

    public static Map<String, List<String>> getBusinessPartnerRolesForClient(RegisteredClient client) {
        return (Map)client.getClientSettings().getSettings().get(BPROLES);
    }

    public static boolean isBprolesScopeEnabled(RegisteredClient client) {
        return (Boolean)client.getClientSettings().getSettings().get(BPROLES_SCOPE_ENABLED);
    }

    @Generated
    public ClientData() {
    }

    @Generated
    public String getClientId() {
        return this.clientId;
    }

    @Generated
    public String getClientSecret() {
        return this.clientSecret;
    }

    @Generated
    public List<String> getRegisteredRedirectUri() {
        return this.registeredRedirectUri;
    }

    @Generated
    public Long getAccessTokenValiditySeconds() {
        return this.accessTokenValiditySeconds;
    }

    @Generated
    public Long getRefreshTokenValiditySeconds() {
        return this.refreshTokenValiditySeconds;
    }

    @Generated
    public AuthContext getContext() {
        return this.context;
    }

    @Generated
    public String getSubject() {
        return this.subject;
    }

    @Generated
    public List<String> getAudience() {
        return this.audience;
    }

    @Generated
    public List<String> getUserroles() {
        return this.userroles;
    }

    @Generated
    public Map<String, List<String>> getBproles() {
        return this.bproles;
    }

    @Generated
    public List<String> getScope() {
        return this.scope;
    }

    @Generated
    public boolean isBprolesScopeEnabled() {
        return this.bprolesScopeEnabled;
    }

    @Generated
    public boolean isRolesPruningEnabled() {
        return this.rolesPruningEnabled;
    }

    @Generated
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    @Generated
    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    @Generated
    public void setRegisteredRedirectUri(List<String> registeredRedirectUri) {
        this.registeredRedirectUri = registeredRedirectUri;
    }

    @Generated
    public void setAccessTokenValiditySeconds(Long accessTokenValiditySeconds) {
        this.accessTokenValiditySeconds = accessTokenValiditySeconds;
    }

    @Generated
    public void setRefreshTokenValiditySeconds(Long refreshTokenValiditySeconds) {
        this.refreshTokenValiditySeconds = refreshTokenValiditySeconds;
    }

    @Generated
    public void setContext(AuthContext context) {
        this.context = context;
    }

    @Generated
    public void setSubject(String subject) {
        this.subject = subject;
    }

    @Generated
    public void setAudience(List<String> audience) {
        this.audience = audience;
    }

    @Generated
    public void setUserroles(List<String> userroles) {
        this.userroles = userroles;
    }

    @Generated
    public void setBproles(Map<String, List<String>> bproles) {
        this.bproles = bproles;
    }

    @Generated
    public void setScope(List<String> scope) {
        this.scope = scope;
    }

    @Generated
    public void setBprolesScopeEnabled(boolean bprolesScopeEnabled) {
        this.bprolesScopeEnabled = bprolesScopeEnabled;
    }

    @Generated
    public void setRolesPruningEnabled(boolean rolesPruningEnabled) {
        this.rolesPruningEnabled = rolesPruningEnabled;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientData)) {
            return false;
        }
        ClientData other = (ClientData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isBprolesScopeEnabled() != other.isBprolesScopeEnabled()) {
            return false;
        }
        if (this.isRolesPruningEnabled() != other.isRolesPruningEnabled()) {
            return false;
        }
        Long this$accessTokenValiditySeconds = this.getAccessTokenValiditySeconds();
        Long other$accessTokenValiditySeconds = other.getAccessTokenValiditySeconds();
        if (this$accessTokenValiditySeconds == null ? other$accessTokenValiditySeconds != null : !((Object)this$accessTokenValiditySeconds).equals(other$accessTokenValiditySeconds)) {
            return false;
        }
        Long this$refreshTokenValiditySeconds = this.getRefreshTokenValiditySeconds();
        Long other$refreshTokenValiditySeconds = other.getRefreshTokenValiditySeconds();
        if (this$refreshTokenValiditySeconds == null ? other$refreshTokenValiditySeconds != null : !((Object)this$refreshTokenValiditySeconds).equals(other$refreshTokenValiditySeconds)) {
            return false;
        }
        String this$clientId = this.getClientId();
        String other$clientId = other.getClientId();
        if (this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId)) {
            return false;
        }
        String this$clientSecret = this.getClientSecret();
        String other$clientSecret = other.getClientSecret();
        if (this$clientSecret == null ? other$clientSecret != null : !this$clientSecret.equals(other$clientSecret)) {
            return false;
        }
        List<String> this$registeredRedirectUri = this.getRegisteredRedirectUri();
        List<String> other$registeredRedirectUri = other.getRegisteredRedirectUri();
        if (this$registeredRedirectUri == null ? other$registeredRedirectUri != null : !((Object)this$registeredRedirectUri).equals(other$registeredRedirectUri)) {
            return false;
        }
        AuthContext this$context = this.getContext();
        AuthContext other$context = other.getContext();
        if (this$context == null ? other$context != null : !((Object)((Object)this$context)).equals((Object)other$context)) {
            return false;
        }
        String this$subject = this.getSubject();
        String other$subject = other.getSubject();
        if (this$subject == null ? other$subject != null : !this$subject.equals(other$subject)) {
            return false;
        }
        List<String> this$audience = this.getAudience();
        List<String> other$audience = other.getAudience();
        if (this$audience == null ? other$audience != null : !((Object)this$audience).equals(other$audience)) {
            return false;
        }
        List<String> this$userroles = this.getUserroles();
        List<String> other$userroles = other.getUserroles();
        if (this$userroles == null ? other$userroles != null : !((Object)this$userroles).equals(other$userroles)) {
            return false;
        }
        Map<String, List<String>> this$bproles = this.getBproles();
        Map<String, List<String>> other$bproles = other.getBproles();
        if (this$bproles == null ? other$bproles != null : !((Object)this$bproles).equals(other$bproles)) {
            return false;
        }
        List<String> this$scope = this.getScope();
        List<String> other$scope = other.getScope();
        return !(this$scope == null ? other$scope != null : !((Object)this$scope).equals(other$scope));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ClientData;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isBprolesScopeEnabled() ? 79 : 97);
        result = result * 59 + (this.isRolesPruningEnabled() ? 79 : 97);
        Long $accessTokenValiditySeconds = this.getAccessTokenValiditySeconds();
        result = result * 59 + ($accessTokenValiditySeconds == null ? 43 : ((Object)$accessTokenValiditySeconds).hashCode());
        Long $refreshTokenValiditySeconds = this.getRefreshTokenValiditySeconds();
        result = result * 59 + ($refreshTokenValiditySeconds == null ? 43 : ((Object)$refreshTokenValiditySeconds).hashCode());
        String $clientId = this.getClientId();
        result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
        String $clientSecret = this.getClientSecret();
        result = result * 59 + ($clientSecret == null ? 43 : $clientSecret.hashCode());
        List<String> $registeredRedirectUri = this.getRegisteredRedirectUri();
        result = result * 59 + ($registeredRedirectUri == null ? 43 : ((Object)$registeredRedirectUri).hashCode());
        AuthContext $context = this.getContext();
        result = result * 59 + ($context == null ? 43 : ((Object)((Object)$context)).hashCode());
        String $subject = this.getSubject();
        result = result * 59 + ($subject == null ? 43 : $subject.hashCode());
        List<String> $audience = this.getAudience();
        result = result * 59 + ($audience == null ? 43 : ((Object)$audience).hashCode());
        List<String> $userroles = this.getUserroles();
        result = result * 59 + ($userroles == null ? 43 : ((Object)$userroles).hashCode());
        Map<String, List<String>> $bproles = this.getBproles();
        result = result * 59 + ($bproles == null ? 43 : ((Object)$bproles).hashCode());
        List<String> $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : ((Object)$scope).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ClientData(clientId=" + this.getClientId() + ", clientSecret=" + this.getClientSecret() + ", registeredRedirectUri=" + String.valueOf(this.getRegisteredRedirectUri()) + ", accessTokenValiditySeconds=" + this.getAccessTokenValiditySeconds() + ", refreshTokenValiditySeconds=" + this.getRefreshTokenValiditySeconds() + ", context=" + String.valueOf((Object)this.getContext()) + ", subject=" + this.getSubject() + ", audience=" + String.valueOf(this.getAudience()) + ", userroles=" + String.valueOf(this.getUserroles()) + ", bproles=" + String.valueOf(this.getBproles()) + ", scope=" + String.valueOf(this.getScope()) + ", bprolesScopeEnabled=" + this.isBprolesScopeEnabled() + ", rolesPruningEnabled=" + this.isRolesPruningEnabled() + ")";
    }
}

