/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.openapi.publisher;

import ch.admin.bit.jeap.openapi.archrepo.client.OpenApiArchitectureRepositoryService;
import ch.admin.bit.jeap.openapi.publisher.TracingTimer;
import ch.admin.bit.jeap.openapi.reader.OpenApiSpecReader;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.info.BuildProperties;
import org.springframework.boot.info.GitProperties;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.scheduling.annotation.Async;

public class OpenApiSpecPublisher {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OpenApiSpecPublisher.class);
    static final String OPEN_API_SPEC_PUBLISHER_TASK_EXECUTOR = "openApiSpecPublisherTaskExecutor";
    private static final String TIMER_NAME = "jeap-publish-open-api-spec";
    private static final String SPAN_NAME = "publish-open-api-spec";
    private final String applicationName;
    private final OpenApiArchitectureRepositoryService openApiArchitectureRepositoryService;
    private final OpenApiSpecReader openApiSpecReader;
    private final BuildProperties buildProperties;
    private final GitProperties gitProperties;
    private final TracingTimer tracingTimer;

    OpenApiSpecPublisher(String applicationName, OpenApiArchitectureRepositoryService openApiArchitectureRepositoryService, OpenApiSpecReader openApiSpecReader, BuildProperties buildProperties, GitProperties gitProperties, TracingTimer tracingTimer) {
        this.applicationName = applicationName;
        this.openApiArchitectureRepositoryService = openApiArchitectureRepositoryService;
        this.openApiSpecReader = openApiSpecReader;
        this.buildProperties = buildProperties;
        this.gitProperties = gitProperties;
        this.tracingTimer = tracingTimer;
    }

    @Async(value="openApiSpecPublisherTaskExecutor")
    public CompletableFuture<Void> publishOpenApiSpecAsync() {
        return this.tracingTimer.traceAndTime(SPAN_NAME, TIMER_NAME, () -> {
            try {
                this.publishOpenApiSpec();
                return CompletableFuture.completedFuture(null);
            }
            catch (Exception e) {
                log.error("Failed to publish OpenAPI spec", (Throwable)e);
                return CompletableFuture.failedFuture(e);
            }
        });
    }

    void publishOpenApiSpec() throws JsonProcessingException {
        String openApiSpec = this.openApiSpecReader.readOpenApiSpec();
        ByteArrayResource resource = this.getByteArrayResource(openApiSpec);
        this.openApiArchitectureRepositoryService.publishOpenApiSpec(this.applicationName, this.getAppVersion(), (Resource)resource);
        log.info("Published OpenAPI specification successfully");
    }

    private ByteArrayResource getByteArrayResource(String openApiSpec) {
        return new ByteArrayResource(openApiSpec.getBytes(StandardCharsets.UTF_8)){

            public String getFilename() {
                return OpenApiSpecPublisher.this.applicationName + "-open-api-spec.json";
            }
        };
    }

    private String getAppVersion() {
        String gitBuildVersion;
        if (this.buildProperties != null) {
            return this.buildProperties.getVersion();
        }
        if (this.gitProperties != null && (gitBuildVersion = this.gitProperties.get("git.build.version")) != null) {
            return gitBuildVersion;
        }
        return "na";
    }
}

