/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.openapi.publisher;

import brave.Tracer;
import ch.admin.bit.jeap.openapi.archrepo.client.OpenApiArchitectureRepositoryService;
import ch.admin.bit.jeap.openapi.publisher.ArchRepoProperties;
import ch.admin.bit.jeap.openapi.publisher.OpenApiSpecPublisher;
import ch.admin.bit.jeap.openapi.publisher.OpenApiSpecPublisherEventListener;
import ch.admin.bit.jeap.openapi.publisher.TracingTimer;
import ch.admin.bit.jeap.openapi.reader.OpenApiSpecReader;
import ch.admin.bit.jeap.security.restclient.OAuth2ClientCredentialsRestClientInitializer;
import io.micrometer.core.instrument.MeterRegistry;
import org.springdoc.core.configuration.SpringDocConfiguration;
import org.springdoc.webmvc.api.OpenApiResource;
import org.springdoc.webmvc.core.configuration.SpringDocWebMvcConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.info.BuildProperties;
import org.springframework.boot.info.GitProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.http.client.ClientHttpRequestInitializer;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.security.oauth2.client.AuthorizedClientServiceOAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientProviderBuilder;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.web.client.RestClient;
import org.springframework.web.client.support.RestClientAdapter;
import org.springframework.web.service.invoker.HttpExchangeAdapter;
import org.springframework.web.service.invoker.HttpServiceProxyFactory;

@AutoConfiguration(after={SpringDocConfiguration.class, SpringDocWebMvcConfiguration.class})
@EnableConfigurationProperties(value={ArchRepoProperties.class})
@ConditionalOnBean(value={OpenApiResource.class})
@ConditionalOnProperty(prefix="jeap.archrepo", name={"enabled"}, havingValue="true", matchIfMissing=true)
@EnableAsync
public class OpenApiSpecPublisherAutoConfiguration {
    @Bean
    public OpenApiSpecReader openApiSpecReader(OpenApiResource openApiResource) {
        return new OpenApiSpecReader(openApiResource);
    }

    @Bean
    @ConditionalOnProperty(prefix="jeap.archrepo", name={"url"})
    public OpenApiArchitectureRepositoryService openApiArchitectureRepositoryService(ClientRegistrationRepository clientRegistrationRepository, OAuth2AuthorizedClientService clientService, RestClient.Builder builder, ArchRepoProperties properties) {
        ClientRegistration clientRegistration = clientRegistrationRepository.findByRegistrationId(properties.getOauthClient());
        if (clientRegistration == null) {
            throw new IllegalStateException("No OAuth2 client registration found with id: " + properties.getOauthClient() + ". Please ensure that the client registration is configured correctly at jeap.archrepo.oauth-client and that an oauth client has been registered in the spring security configuration at spring.security.oauth2.client.registration." + properties.getOauthClient());
        }
        RestClient restClient = builder.clone().baseUrl(properties.getUrl()).requestInitializer((ClientHttpRequestInitializer)new OAuth2ClientCredentialsRestClientInitializer(this.authorizedClientManager(clientRegistrationRepository, clientService), clientRegistration, false)).build();
        return (OpenApiArchitectureRepositoryService)HttpServiceProxyFactory.builderFor((HttpExchangeAdapter)RestClientAdapter.create((RestClient)restClient)).build().createClient(OpenApiArchitectureRepositoryService.class);
    }

    private OAuth2AuthorizedClientManager authorizedClientManager(ClientRegistrationRepository clientRegistrationRepository, OAuth2AuthorizedClientService clientService) {
        AuthorizedClientServiceOAuth2AuthorizedClientManager authorizedClientManager = new AuthorizedClientServiceOAuth2AuthorizedClientManager(clientRegistrationRepository, clientService);
        OAuth2AuthorizedClientProvider authorizedClientProvider = OAuth2AuthorizedClientProviderBuilder.builder().clientCredentials().build();
        authorizedClientManager.setAuthorizedClientProvider(authorizedClientProvider);
        return authorizedClientManager;
    }

    @Bean
    @ConditionalOnBean(value={OpenApiArchitectureRepositoryService.class})
    public OpenApiSpecPublisher openApiSpecPublisher(OpenApiArchitectureRepositoryService openApiArchitectureRepositoryService, OpenApiSpecReader openApiSpecReader, @Value(value="${spring.application.name}") String applicationName, @Autowired(required=false) BuildProperties buildProperties, @Autowired(required=false) GitProperties gitProperties, @Autowired(required=false) Tracer tracer, @Autowired(required=false) MeterRegistry meterRegistry) {
        return new OpenApiSpecPublisher(applicationName, openApiArchitectureRepositoryService, openApiSpecReader, buildProperties, gitProperties, new TracingTimer(tracer, meterRegistry));
    }

    @Bean
    @ConditionalOnBean(value={OpenApiSpecPublisher.class})
    public OpenApiSpecPublisherEventListener openApiSpecPublisherEventListener(OpenApiSpecPublisher openApiSpecPublisher) {
        return new OpenApiSpecPublisherEventListener(openApiSpecPublisher);
    }

    @Bean(value={"openApiSpecPublisherTaskExecutor"})
    @ConditionalOnBean(value={OpenApiSpecPublisher.class})
    public ThreadPoolTaskExecutor openApiSpecPublisherTaskExecutor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(0);
        executor.setMaxPoolSize(1);
        executor.setQueueCapacity(1);
        executor.setThreadNamePrefix("open-api-publisher-");
        executor.initialize();
        return executor;
    }
}

