/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.processarchive.crypto;

import ch.admin.bit.jeap.crypto.api.KeyId;
import ch.admin.bit.jeap.crypto.api.KeyIdCryptoService;
import ch.admin.bit.jeap.crypto.api.KeyReference;
import ch.admin.bit.jeap.crypto.api.KeyReferenceCryptoService;
import ch.admin.bit.jeap.crypto.vault.keymanagement.VaultKeyLocation;
import ch.admin.bit.jeap.processarchive.crypto.ArchiveDataEncryption;
import ch.admin.bit.jeap.processarchive.plugin.api.archivedata.schema.EncryptionKeyId;
import ch.admin.bit.jeap.processarchive.plugin.api.archivedata.schema.EncryptionKeyReference;
import io.micrometer.core.annotation.Timed;
import java.util.Optional;
import lombok.Generated;
import org.springframework.stereotype.Component;

@Component
public class ArchiveCryptoService {
    private final Optional<KeyReferenceCryptoService> keyReferenceCryptoService;
    private final Optional<KeyIdCryptoService> keyIdCryptoService;

    @Timed(value="jeap_pas_encrypt_payload", description="Encrypt payload with crypto service and return encrypted payload")
    public byte[] encrypt(byte[] payload, ArchiveDataEncryption encryption) {
        if (encryption.getEncryptionKeyReference() != null) {
            return this.encrypt(payload, encryption.getEncryptionKeyReference());
        }
        if (encryption.getEncryptionKeyId() != null) {
            return this.encrypt(payload, encryption.getEncryptionKeyId());
        }
        throw new IllegalStateException("Unexpected encryption invocation - no key reference or ID configured");
    }

    private byte[] encrypt(byte[] payload, EncryptionKeyReference encryptionKeyReference) {
        KeyReference vaultKeyRef = VaultKeyLocation.asKeyReference((String)encryptionKeyReference.getSecretEnginePath(), (String)encryptionKeyReference.getKeyName());
        return this.getCryptoService().encrypt(payload, vaultKeyRef);
    }

    private KeyReferenceCryptoService getCryptoService() {
        return this.keyReferenceCryptoService.orElseThrow(() -> new IllegalStateException("No Bean KeyReferenceCryptoService found"));
    }

    private byte[] encrypt(byte[] payload, EncryptionKeyId encryptionKeyId) {
        KeyId keyId = KeyId.of((String)encryptionKeyId.getKeyId());
        return this.getKeyIdCryptoService().encrypt(payload, keyId);
    }

    private KeyIdCryptoService getKeyIdCryptoService() {
        return this.keyIdCryptoService.orElseThrow(() -> new IllegalStateException("No Bean KeyIdCryptoService found"));
    }

    @Generated
    public ArchiveCryptoService(Optional<KeyReferenceCryptoService> keyReferenceCryptoService, Optional<KeyIdCryptoService> keyIdCryptoService) {
        this.keyReferenceCryptoService = keyReferenceCryptoService;
        this.keyIdCryptoService = keyIdCryptoService;
    }
}

