/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.processarchive.kafka.event;

import ch.admin.bit.jeap.domainevent.avro.AvroDomainEventBuilder;
import ch.admin.bit.jeap.event.shared.processarchive.archivedartifactversioncreated.ArchivedArtifactMetadata;
import ch.admin.bit.jeap.event.shared.processarchive.archivedartifactversioncreated.ArchivedArtifactReference;
import ch.admin.bit.jeap.event.shared.processarchive.archivedartifactversioncreated.ArchivedArtifactTypeReference;
import ch.admin.bit.jeap.event.shared.processarchive.archivedartifactversioncreated.ArchivedArtifactVersionCreatedPayload;
import ch.admin.bit.jeap.event.shared.processarchive.archivedartifactversioncreated.ArchivedArtifactVersionReferences;
import ch.admin.bit.jeap.event.shared.processarchive.archivedartifactversioncreated.Expiration;
import ch.admin.bit.jeap.event.shared.processarchive.archivedartifactversioncreated.SharedArchivedArtifactVersionCreatedEvent;
import ch.admin.bit.jeap.event.shared.processarchive.archivedartifactversioncreated.StorageObjectReference;
import ch.admin.bit.jeap.messaging.avro.AvroMessageType;
import ch.admin.bit.jeap.messaging.model.MessagePayload;
import ch.admin.bit.jeap.messaging.model.MessageReferences;
import ch.admin.bit.jeap.processarchive.kafka.event.Hashes;
import ch.admin.bit.jeap.processarchive.plugin.api.archivedartifact.ArchivedArtifact;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class ArchivedArtifactVersionCreatedEventBuilder
extends AvroDomainEventBuilder<ArchivedArtifactVersionCreatedEventBuilder, SharedArchivedArtifactVersionCreatedEvent> {
    private String serviceName;
    private String systemName;
    private ArchivedArtifact archivedArtifact;
    private String referenceIdType;
    private int expirationDays;

    public static ArchivedArtifactVersionCreatedEventBuilder builder() {
        return new ArchivedArtifactVersionCreatedEventBuilder();
    }

    private ArchivedArtifactVersionCreatedEventBuilder() {
        super(SharedArchivedArtifactVersionCreatedEvent::new);
    }

    public SharedArchivedArtifactVersionCreatedEvent build() {
        this.setReferences(this.buildReferences());
        this.setPayload(this.buildPayload());
        return (SharedArchivedArtifactVersionCreatedEvent)super.build();
    }

    private MessageReferences buildReferences() {
        String referenceIdHash = Hashes.hashReferenceId(this.archivedArtifact.getArchiveData().getReferenceId(), this.archivedArtifact.getReferenceIdType());
        String referenceIdTypeHash = Hashes.hashReferenceIdType(this.archivedArtifact.getReferenceIdType());
        return ArchivedArtifactVersionReferences.newBuilder().setArchivedArtifact(ArchivedArtifactReference.newBuilder().setReferenceId(this.archivedArtifact.getArchiveData().getReferenceId()).setVersion((String)Optional.ofNullable(this.archivedArtifact.getArchiveData().getVersion()).map(Object::toString).orElse(null)).setReferenceIdHash(referenceIdHash).setReferenceIdType(this.referenceIdType).setReferenceIdTypeHash(referenceIdTypeHash).build()).setArchivedArtifactType(ArchivedArtifactTypeReference.newBuilder().setContentType(this.archivedArtifact.getArchiveData().getContentType()).setSystem(this.archivedArtifact.getArchiveData().getSystem()).setDataSchemaType(this.archivedArtifact.getArchiveData().getSchema()).setDataSchemaVersion(this.archivedArtifact.getArchiveData().getSchemaVersion()).build()).setStorageObject(StorageObjectReference.newBuilder().setStorageObjectBucket(this.archivedArtifact.getStorageObjectBucket()).setStorageObjectKey(this.archivedArtifact.getStorageObjectKey()).setStorageObjectVersionId(this.archivedArtifact.getStorageObjectVersionId()).build()).build();
    }

    protected String getServiceName() {
        return this.serviceName;
    }

    protected String getSystemName() {
        return this.systemName;
    }

    protected ArchivedArtifactVersionCreatedEventBuilder self() {
        return this;
    }

    public ArchivedArtifactVersionCreatedEventBuilder sender(String systemName, String serviceName) {
        this.systemName = systemName;
        this.serviceName = serviceName;
        return this;
    }

    public ArchivedArtifactVersionCreatedEventBuilder archivedArtifact(ArchivedArtifact archivedArtifact) {
        this.setProcessId(archivedArtifact.getProcessId());
        this.idempotenceId = archivedArtifact.getIdempotenceId() + "-event";
        this.archivedArtifact = archivedArtifact;
        this.expirationDays = archivedArtifact.getExpirationDays();
        return this;
    }

    public ArchivedArtifactVersionCreatedEventBuilder referenceIdType(String referenceIdType) {
        this.referenceIdType = referenceIdType;
        return this;
    }

    private MessagePayload buildPayload() {
        return ArchivedArtifactVersionCreatedPayload.newBuilder().setMetadata(this.buildMetadata()).setExpiration(Expiration.newBuilder().setDays(this.expirationDays).build()).build();
    }

    private List<ArchivedArtifactMetadata> buildMetadata() {
        return this.archivedArtifact.getArchiveData().getMetadata().stream().map(metadata -> ArchivedArtifactMetadata.newBuilder().setName(metadata.getName()).setValue(metadata.getValue()).build()).collect(Collectors.toList());
    }

    public static AvroMessageType messageType() {
        AvroMessageType type = new AvroMessageType();
        type.setName(SharedArchivedArtifactVersionCreatedEvent.getClassSchema().getName());
        type.setVersion("2.0.1");
        return type;
    }
}

