/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.processarchive.kafka.event;

import java.nio.charset.StandardCharsets;
import java.security.Provider;
import java.security.Security;
import org.apache.commons.codec.binary.Hex;
import org.bouncycastle.crypto.digests.Blake3Digest;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

class Hashes {
    private static final int DEFAULT_DIGEST_LENGTH_IN_BYTES = 32;

    Hashes() {
    }

    static String hashReferenceId(String referenceId, String referenceIdType) {
        return Hashes.hash(referenceId, referenceIdType);
    }

    static String hashReferenceIdType(String referenceIdType) {
        return Hashes.hash(referenceIdType);
    }

    private static String hash(String ... parts) {
        Blake3Digest messageDigest = new Blake3Digest(32);
        for (String part : parts) {
            byte[] partBytes = part.getBytes(StandardCharsets.UTF_8);
            messageDigest.update(partBytes, 0, partBytes.length);
        }
        return Hashes.generateHash(messageDigest);
    }

    private static String generateHash(Blake3Digest messageDigest) {
        byte[] hashedString = new byte[messageDigest.getDigestSize()];
        messageDigest.doFinal(hashedString, 0);
        return Hex.encodeHexString((byte[])hashedString);
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

