/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.processarchive.kafka.event;

import jakarta.annotation.PostConstruct;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import jakarta.validation.constraints.NotEmpty;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="jeap.processarchive.archivedartifact")
public class ArchivedArtifactEventProperties {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ArchivedArtifactEventProperties.class);
    private boolean enabled = true;
    @NotEmpty
    private String systemId;
    @NotEmpty
    private String eventTopic;
    @NotEmpty
    private String systemName;
    @NotEmpty
    private String serviceName;

    @PostConstruct
    void validateConfiguration() {
        if (!this.enabled) {
            log.info("Publishing SharedArchivedArtifactVersionCreatedEvent is not enabled");
            return;
        }
        this.validateProperties();
        log.info(this.toString());
    }

    private void validateProperties() {
        try (ValidatorFactory factory = Validation.buildDefaultValidatorFactory();){
            Validator validator = factory.getValidator();
            Set violations = validator.validate((Object)this, new Class[0]);
            if (!violations.isEmpty()) {
                String errorMessage = violations.stream().map(ConstraintViolation::toString).collect(Collectors.joining(", "));
                throw new IllegalStateException(errorMessage);
            }
        }
    }

    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    @Generated
    public String getSystemId() {
        return this.systemId;
    }

    @Generated
    public String getEventTopic() {
        return this.eventTopic;
    }

    @Generated
    public String getSystemName() {
        return this.systemName;
    }

    @Generated
    public String getServiceName() {
        return this.serviceName;
    }

    @Generated
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Generated
    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    @Generated
    public void setEventTopic(String eventTopic) {
        this.eventTopic = eventTopic;
    }

    @Generated
    public void setSystemName(String systemName) {
        this.systemName = systemName;
    }

    @Generated
    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ArchivedArtifactEventProperties)) {
            return false;
        }
        ArchivedArtifactEventProperties other = (ArchivedArtifactEventProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        String this$systemId = this.getSystemId();
        String other$systemId = other.getSystemId();
        if (this$systemId == null ? other$systemId != null : !this$systemId.equals(other$systemId)) {
            return false;
        }
        String this$eventTopic = this.getEventTopic();
        String other$eventTopic = other.getEventTopic();
        if (this$eventTopic == null ? other$eventTopic != null : !this$eventTopic.equals(other$eventTopic)) {
            return false;
        }
        String this$systemName = this.getSystemName();
        String other$systemName = other.getSystemName();
        if (this$systemName == null ? other$systemName != null : !this$systemName.equals(other$systemName)) {
            return false;
        }
        String this$serviceName = this.getServiceName();
        String other$serviceName = other.getServiceName();
        return !(this$serviceName == null ? other$serviceName != null : !this$serviceName.equals(other$serviceName));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ArchivedArtifactEventProperties;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        String $systemId = this.getSystemId();
        result = result * 59 + ($systemId == null ? 43 : $systemId.hashCode());
        String $eventTopic = this.getEventTopic();
        result = result * 59 + ($eventTopic == null ? 43 : $eventTopic.hashCode());
        String $systemName = this.getSystemName();
        result = result * 59 + ($systemName == null ? 43 : $systemName.hashCode());
        String $serviceName = this.getServiceName();
        result = result * 59 + ($serviceName == null ? 43 : $serviceName.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ArchivedArtifactEventProperties(enabled=" + this.isEnabled() + ", systemId=" + this.getSystemId() + ", eventTopic=" + this.getEventTopic() + ", systemName=" + this.getSystemName() + ", serviceName=" + this.getServiceName() + ")";
    }

    @Generated
    public ArchivedArtifactEventProperties() {
    }
}

