/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.processarchive.kafka.event;

import ch.admin.bit.jeap.event.shared.processarchive.archivedartifactversioncreated.SharedArchivedArtifactVersionCreatedEvent;
import ch.admin.bit.jeap.messagetype.shared.processid.ProcessIdMessageKey;
import ch.admin.bit.jeap.messaging.avro.AvroMessage;
import ch.admin.bit.jeap.messaging.avro.AvroMessageKey;
import ch.admin.bit.jeap.processarchive.kafka.KafkaException;
import ch.admin.bit.jeap.processarchive.kafka.event.ArchivedArtifactEventProperties;
import java.util.concurrent.ExecutionException;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.stereotype.Component;

@Component
public class ProcessArchiveEventPublisher {
    private final String topic;
    private final KafkaTemplate<AvroMessageKey, AvroMessage> kafkaTemplate;

    ProcessArchiveEventPublisher(KafkaTemplate<AvroMessageKey, AvroMessage> kafkaTemplate, ArchivedArtifactEventProperties properties) {
        this.kafkaTemplate = kafkaTemplate;
        this.topic = properties.getEventTopic();
    }

    public void publish(SharedArchivedArtifactVersionCreatedEvent event) {
        try {
            ProcessIdMessageKey key = ProcessIdMessageKey.newBuilder().setProcessId(event.getProcessId()).build();
            this.kafkaTemplate.send(this.topic, (Object)key, (Object)event).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw KafkaException.interrupted(e);
        }
        catch (ExecutionException e) {
            throw KafkaException.sendFailed(e);
        }
    }
}

