/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.processarchive.kafka;

import ch.admin.bit.jeap.processarchive.domain.configuration.DomainEventArchiveConfiguration;
import ch.admin.bit.jeap.processarchive.domain.event.DomainEventListenerAdapter;
import ch.admin.bit.jeap.processarchive.kafka.KafkaDomainEventConsumerFactory;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
class KafkaDomainEventListenerAdapter
implements DomainEventListenerAdapter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KafkaDomainEventListenerAdapter.class);
    private final KafkaDomainEventConsumerFactory domainEventConsumerFactory;

    public void start(List<DomainEventArchiveConfiguration> configurations) {
        Set<DomainEventArchiveConfiguration> configWithoutCluster = configurations.stream().filter(config -> config.getClusterName() == null).collect(Collectors.toSet());
        this.startConsumer(configWithoutCluster, null);
        Map configurationsByCluster = configurations.stream().filter(config -> config.getClusterName() != null).collect(Collectors.groupingBy(DomainEventArchiveConfiguration::getClusterName, Collectors.toSet()));
        for (Map.Entry configEntry : configurationsByCluster.entrySet()) {
            this.startConsumer(configEntry.getValue(), configEntry.getKey());
        }
    }

    private void startConsumer(Set<DomainEventArchiveConfiguration> configs, String clusterName) {
        Map eventsByTopic = configs.stream().collect(Collectors.groupingBy(DomainEventArchiveConfiguration::getTopicName, Collectors.mapping(DomainEventArchiveConfiguration::getEventName, Collectors.toSet())));
        for (Map.Entry topicConfigEntry : eventsByTopic.entrySet()) {
            this.domainEventConsumerFactory.startConsumer(topicConfigEntry.getKey(), topicConfigEntry.getValue(), clusterName);
        }
    }

    @Generated
    public KafkaDomainEventListenerAdapter(KafkaDomainEventConsumerFactory domainEventConsumerFactory) {
        this.domainEventConsumerFactory = domainEventConsumerFactory;
    }
}

