/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.processarchive.kafka;

import ch.admin.bit.jeap.domainevent.DomainEvent;
import ch.admin.bit.jeap.domainevent.avro.AvroDomainEvent;
import ch.admin.bit.jeap.messaging.avro.AvroMessageKey;
import ch.admin.bit.jeap.messaging.avro.errorevent.MessageHandlerException;
import ch.admin.bit.jeap.messaging.avro.errorevent.MessageHandlerExceptionInformation;
import ch.admin.bit.jeap.processarchive.domain.archive.ProcessArchiveException;
import ch.admin.bit.jeap.processarchive.domain.event.DomainEventReceiver;
import ch.admin.bit.jeap.processarchive.kafka.KafkaException;
import java.util.Set;
import lombok.Generated;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.listener.AcknowledgingMessageListener;
import org.springframework.kafka.support.Acknowledgment;

class KafkaMessageListener
implements AcknowledgingMessageListener<AvroMessageKey, AvroDomainEvent> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KafkaMessageListener.class);
    private static final String ERROR_CODE = "domain-event-archive-failed";
    private final Set<String> eventNames;
    private final DomainEventReceiver domainEventReceiver;

    public void onMessage(ConsumerRecord<AvroMessageKey, AvroDomainEvent> record, Acknowledgment acknowledgment) {
        try {
            this.handleDomainEvent(record);
        }
        catch (KafkaException ex) {
            throw MessageHandlerException.builder().temporality(MessageHandlerExceptionInformation.Temporality.TEMPORARY).cause((Throwable)ex).message("Kafka exception while handling domain event").errorCode("kafka-exception").description(ex.getMessage()).build();
        }
        catch (ProcessArchiveException ex) {
            throw MessageHandlerException.builder().temporality(ex.isRetryable() ? MessageHandlerExceptionInformation.Temporality.TEMPORARY : MessageHandlerExceptionInformation.Temporality.PERMANENT).cause((Throwable)ex).message("Exception while handling domain event").errorCode("process-archive-failed").description(ex.getMessage()).build();
        }
        acknowledgment.acknowledge();
    }

    private void handleDomainEvent(ConsumerRecord<AvroMessageKey, AvroDomainEvent> record) {
        String receivedEventName = ((AvroDomainEvent)record.value()).getType().getName();
        if (this.eventNames.contains(receivedEventName)) {
            DomainEvent domainEvent = (DomainEvent)record.value();
            this.notifyEventReceived(domainEvent);
        } else {
            this.logIgnoredEvent(record);
        }
    }

    private void notifyEventReceived(DomainEvent domainEvent) {
        try {
            this.domainEventReceiver.domainEventReceived(domainEvent);
        }
        catch (ProcessArchiveException ex) {
            throw this.createMessageHandlerException((Exception)((Object)ex), ex.isRetryable() ? MessageHandlerExceptionInformation.Temporality.TEMPORARY : MessageHandlerExceptionInformation.Temporality.PERMANENT);
        }
        catch (Exception ex) {
            throw this.createMessageHandlerException(ex, MessageHandlerExceptionInformation.Temporality.TEMPORARY);
        }
    }

    private MessageHandlerException createMessageHandlerException(Exception ex, MessageHandlerExceptionInformation.Temporality temporality) {
        return MessageHandlerException.builder().description("Failed to archive data for domain event").temporality(temporality).message(ex.getMessage()).errorCode(ERROR_CODE).cause((Throwable)ex).build();
    }

    private void logIgnoredEvent(ConsumerRecord<AvroMessageKey, AvroDomainEvent> record) {
        log.debug("Ignoring event {} on topic {} as there is no matching domain event archive configuration", (Object)((AvroDomainEvent)record.value()).getType().getName(), (Object)record.topic());
    }

    @Generated
    public KafkaMessageListener(Set<String> eventNames, DomainEventReceiver domainEventReceiver) {
        this.eventNames = eventNames;
        this.domainEventReceiver = domainEventReceiver;
    }
}

